/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件为 webUI 控件
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 *************************************************************************************************/

/* exported mc_ui_lab */
/* exported mc_ui_edit */
/* exported mc_ui_step */
/* exported mc_ui_checkbox */
/* exported mc_ui_slider */
/* exported mc_ui_select */
/* exported mc_setinp_iint */
/* exported mc_setinp_iuint */
/* exported mc_setinp_ihex */
/* exported mc_setinp_ifloat */
/* exported mc_setinp_i */
/* exported mc_item_js_fun */
/* exported mc_ui_radio*/
/* exported mc_ui_lan*/
/* exported mc_updata_scroll_bar_after_trans*/
/* exported mc_loading_wait*/
/* exported mc_loading_wait_remove*/
/* exported mc_ui_table*/
/* exported mc_ui_tabs*/

/* global $ */

// 定义传递函数
var g_str_attr_lab_val_chg = "on_val_chg";
var g_obj_func_name_map = {};
// 步进编辑框或下拉菜单是否在编辑状态 避免与mc_box键盘事件冲突
// eslint-disable-next-line no-unused-vars
var b_edit_step_select = false;

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取动态ID
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<String> } 动态ID
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_id() {
    return new Date().getTime() + (Math.random() * 1000).toFixed(0);
}

// 标签栏/静态文本框
function mc_ui_lab() {
    var str_lab_id = "";
    var str_lab_val = "";
    var str_lab_title = "";
    var ary_class = ["mc_lab"];
    //样式 [[width,20px],[height,20px]...]
    var ary_style = [];

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置静态文本框的样式 宽
   * 参数:
   *     @param { Promise<String> } str_width 宽度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_width = function (str_width) {
        if ("string" !== typeof str_width) {
            return false;
        }
        ary_style.push(["width", str_width]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置静态文本框的样式 宽 操作dom
   * 参数:
   *     @param { Promise<String> } str_width 宽度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_width = function (str_width) {
        if ("string" !== typeof str_width) {
            return false;
        }
        $("#" + str_lab_id).css("width", str_width);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置静态文本框的样式 高
   * 参数:
   *     @param { Promise<String> } str_height 高度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_height = function (str_height) {
        if ("string" !== typeof str_height) {
            return false;
        }
        ary_style.push(["height", str_height]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置静态文本框的样式 高 操作dom
   * 参数:
   *     @param { Promise<String> } str_height 高度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_height = function (str_height) {
        if ("string" !== typeof str_height) {
            return false;
        }
        $("#" + str_lab_id).css("height", str_height);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置静态文本框的样式 字体颜色
   * 参数:
   *     @param { Promise<String> } str_color 颜色
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_color = function (str_color) {
        if ("string" !== typeof str_color) {
            return false;
        }
        ary_style.push(["color", str_color]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置静态文本框的样式 字体颜色 操作dom
   * 参数:
   *     @param { Promise<String> } str_color 颜色
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_color = function (str_color) {
        if ("string" !== typeof str_color) {
            return false;
        }
        $("#" + str_lab_id).css("color", str_color);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置静态文本框的样式 水平方向对其方式
   * 参数:
   *     @param { Promise<String> } str_direction 方向
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_direction = function (str_direction) {
        if ("string" !== typeof str_direction) {
            return false;
        }
        ary_style.push(["text-align", str_direction]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置静态文本框的样式 水平方向对其方式 操作dom
   * 参数:
   *     @param { Promise<String> } str_direction 方向
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_direction = function (str_direction) {
        if ("string" !== typeof str_direction) {
            return false;
        }
        $("#" + str_lab_id).css("text-align", str_direction);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置静态文本框的样式 垂直方向对其方式
   * 参数:
   *     @param { Promise<String> } str_vertical 偏移量
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_vertical = function (str_vertical) {
        if ("string" !== typeof str_vertical) {
            return false;
        }
        ary_style.push(["line-height", str_vertical]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置静态文本框的样式 垂直方向对其方式 操作dom
   * 参数:
   *     @param { Promise<String> } str_vertical 偏移量
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_vertical = function (str_vertical) {
        if ("string" !== typeof str_vertical) {
            return false;
        }
        $("#" + str_lab_id).css("line-height", str_vertical);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    静态文本框添加class类
   * 参数:
   *     @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 添加成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_add_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length) {
            return false;
        }
        ary_class.push(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    静态文本框添加class类 操作dom
   * 参数:
   *     @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 添加成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_add_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length) {
            return false;
        }
        $("#" + str_lab_id).addClass(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    移除静态文本框的class类
   * 参数:
   *     @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 添加成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_del_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length || 0 === ary_style.length) {
            return false;
        }
        for (var idx_css = 0; idx_css < ary_class.length; idx_css++) {
            if (ary_class[idx_css] === str_css) {
                ary_class.splice(idx_css, 1);
                break;
            }
        }
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    移除静态文本框的class类 操作dom
   * 参数:
   *     @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 添加成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_del_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length || 0 === ary_style.length) {
            return false;
        }
        $("#" + str_lab_id).removeClass(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置静态文本框的内容
   * 参数:
   *    @param { Promise<String> } str_val 内容
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_val = function (str_val) {
        if ("string" !== typeof str_val || 0 === str_val.length) {
            return false;
        }
        str_lab_val = str_val;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置静态文本框的内容 操作dom
   * 参数:
   *    @param { Promise<String> } str_val 内容
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_val = function (str_val) {
        if ("string" !== typeof str_val || 0 === str_val.length) {
            return false;
        }
        $("#" + str_lab_id).text(str_val);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    取得静态文本框的内容
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     静态文本框的内容
   *     null 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_val = function () {
        if (0 === str_lab_val.length) {
            return null;
        }
        return str_lab_val;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    取得静态文本框的内容 操作dom
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     静态文本框的内容
   *     null 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_dom_val = function () {
        if (0 === str_lab_val.length) {
            return null;
        }
        return $("#" + str_lab_id).html();
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    取得静态文本框的ID
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     静态文本框的ID
   *     null 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_id = function () {
        if (0 === str_lab_id.length) {
            return null;
        }
        return str_lab_id;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    取得静态文本框的ID 操作dom
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     静态文本框的ID
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_dom_id = function () {
        return $("#" + str_lab_id).attr("id");
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置静态文本框的title
   * 参数:
   *    @param { Promise<String> } str_title title值
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_title = function (str_title) {
        if ("string" !== typeof str_title || 0 === str_title.length) {
            return false;
        }
        str_lab_title = str_title;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置静态文本框的title 操作dom
   * 参数:
   *    @param { Promise<String> } str_title title值
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_title = function (str_title) {
        if ("string" !== typeof str_title || 0 === str_title.length) {
            return false;
        }
        $("#" + str_lab_id).attr("title", str_title);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    创建静态文本框标签
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     静态文本框标签
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_html_txt = function () {
        str_lab_id = "mc_lab" + mc_get_id();
        var str_class_list = "";
        var str_style_list = "";

        // 类数组转化为字符串
        for (var idx_class = 0; idx_class < ary_class.length; idx_class++) {
            str_class_list += ary_class[idx_class] + " ";
        }
        str_class_list = str_class_list.trim();
        // 样式数组转化为字符串 background: red;color: aqua;
        if (0 !== ary_style.length) {
            for (var idx_style = 0; idx_style < ary_style.length; idx_style++) {
                str_style_list += ary_style[idx_style][0] + ":" + ary_style[idx_style][1] + ";";
            }
            str_style_list = str_style_list.trim();
        }
        return "<div class='" + str_class_list + "' id='" + str_lab_id + "' title = '" + str_lab_title + "' style='" + str_style_list + "'>" + str_lab_val + "</div>";
    };
}

// 编辑框
function mc_ui_edit() {
    var str_edit_id = "";
    var str_edit_val = "";
    var str_edit_title = "";
    //数据类型
    var str_edit_type = "";
    //默认最大值
    var str_edit_max = (Math.pow(2, 32) - 1).toString();
    var str_edit_min = "-9999";
    var ary_class = ["mc_edit"];
    var ary_style = [];
    // 默认值位数
    var ui_default_digit = 0;
    // 是否禁用
    var str_disabled = "true";

    // 数值改变触发 返回当前id与当前值 接收传递函数
    this.on_val_chg = function () {};

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的样式 宽
   * 参数:
   *    @param { Promise<String> } str_width 宽度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_width = function (str_width) {
        if ("string" !== typeof str_width) {
            return false;
        }
        ary_style.push(["width", str_width]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的样式 宽 操作dom
   * 参数:
   *    @param { Promise<String> } str_width 宽度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_width = function (str_width) {
        if ("string" !== typeof str_width) {
            return false;
        }
        $("#" + str_edit_id).css("width", str_width);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的样式 高
   * 参数:
   *    @param { Promise<String> } str_height 高度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_height = function (str_height) {
        if ("string" !== typeof str_height) {
            return false;
        }
        ary_style.push(["height", str_height], ["line-height", str_height]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的样式 高 操作dom
   * 参数:
   *    @param { Promise<String> } str_height 高度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_height = function (str_height) {
        if ("string" !== typeof str_height) {
            return false;
        }
        $("#" + str_edit_id).css({ height: str_height, "line-height": str_height });
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的样式 字体颜色
   * 参数:
   *    @param { Promise<String> } str_color 颜色
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_color = function (str_color) {
        if ("string" !== typeof str_color) {
            return false;
        }
        ary_style.push(["color", str_color]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的样式 字体颜色 操作dom
   * 参数:
   *    @param { Promise<String> } str_color 颜色
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_color = function (str_color) {
        if ("string" !== typeof str_color) {
            return false;
        }
        $("#" + str_edit_id).css("color", str_color);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框文字的水平对齐方式 left right center
   * 参数:
   *    @param { Promise<String> } str_direction 方向
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_direction = function (str_direction) {
        if ("string" !== typeof str_direction) {
            return false;
        }
        ary_style.push(["text-align", str_direction]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框文字的水平对齐方式 left right center 操作dom
   * 参数:
   *    @param { Promise<String> } str_direction 方向
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_direction = function (str_direction) {
        if ("string" !== typeof str_direction) {
            return false;
        }
        $("#" + str_edit_id).css("text-align", str_direction);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    添加编辑框的class类
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 添加成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_add_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length || "mc_edit" === str_css) {
            return false;
        }
        ary_class.push(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    添加编辑框的class类 操作dom
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 添加成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_add_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length || "mc_edit" === str_css) {
            return false;
        }
        $("#" + str_edit_id).addClass(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    移除编辑框的class类
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 移除成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_del_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length || 0 === ary_class.length || "mc_edit" === str_css) {
            return false;
        }
        for (var idx_css = 0; idx_css < ary_class.length; idx_css++) {
            if (ary_class[idx_css] === str_css) {
                ary_class.splice(idx_css, 1);
                break;
            }
        }
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    移除编辑框的class类 操作dom
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 移除成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_del_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length || "mc_edit" === str_css) {
            return false;
        }
        $("#" + str_edit_id).removeClass(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的内容
   * 参数:
   *    @param { Promise<String> } str_val 内容字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_val = function (str_val) {
        if ("string" !== typeof str_val || 0 === str_val.length) {
            return false;
        }
        // 效验前位数
        ui_default_digit = str_val.length;
        if ("-" === str_val[0]) {
            ui_default_digit = str_val.length - 1;
        }
        str_edit_val = mc_edit_val_check(str_val, str_edit_type, str_edit_min, str_edit_max, ui_default_digit);
        // 效验后位数
        ui_default_digit = str_edit_val.length;
        if ("-" === str_edit_val[0]) {
            ui_default_digit = str_edit_val.length - 1;
        }
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的内容 操作dom
   * 参数:
   *    @param {Promise<String>} str_val 内容字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_val = function (str_val) {
        if ("string" !== typeof str_val || 0 === str_val.length) {
            return false;
        }
        // 数据类型
        var str_val_type = $("#" + str_edit_id).attr("mc_edit_type");
        // 最大最小值
        var str_val_min = $("#" + str_edit_id).attr("cui_min_val");
        var str_val_max = $("#" + str_edit_id).attr("cui_max_val");
        // 内容位数
        var i_default_digit = str_val.length;

        if ("-" === str_val[0]) {
            i_default_digit -= 1;
        }
        var s_edit_val = mc_edit_val_check(str_val, str_val_type, str_val_min, str_val_max, i_default_digit);

        // 记录位数
        ui_default_digit = s_edit_val.length;

        // 负数去掉符号位
        if ("-" === s_edit_val[0]) {
            ui_default_digit -= 1;
        }
        $("#" + str_edit_id).text(s_edit_val).attr("default_digit", ui_default_digit);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    获取编辑框的内容
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     编辑框的内容
   *     null 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_val = function () {
        if (0 === str_edit_val.length) {
            return null;
        }
        return str_edit_val;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    获取编辑框的内容 操作dom
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     编辑框的内容
   *     null 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_dom_val = function () {
        return $("#" + str_edit_id).text();
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    获取编辑框的ID
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<Strign> }
   *     编辑框的ID
   *     null 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_id = function () {
        if (0 === str_edit_id.length) {
            return null;
        }
        return str_edit_id;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    获取编辑框的ID 操作dom
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<Strign> }
   *     编辑框的ID
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_dom_id = function () {
        return $("#" + str_edit_id).attr("id");
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的title
   * 参数:
   *    @param { Promise<String> } str_title title字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_title = function (str_title) {
        if ("string" !== typeof str_title || 0 === str_title.length) {
            return false;
        }
        str_edit_title = str_title;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的title 操作dom
   * 参数:
   *    @param { Promise<String> } str_title title字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_title = function (str_title) {
        if ("string" !== typeof str_title || 0 === str_title.length) {
            return false;
        }
        $("#" + str_edit_id).attr("title", str_title);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的数据类型 int整数 uint正整数 hex十六进制数 float浮点数和整数
   * 参数:
   *    @param { Promise<String> } str_type 数据类型
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_type = function (str_type) {
        if ("string" !== typeof str_type || 0 === str_type.length) {
            return false;
        }
        str_edit_type = str_type;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的数据类型 int整数 uint正整数 hex十六进制数 flost浮点数和整数 操作dom
   * 参数:
   *    @param { Promise<String> } str_type 数据类型
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_type = function (str_type) {
        if ("string" !== typeof str_type || 0 === str_type.length) {
            return false;
        }
        $("#" + str_edit_id).on("keyup", function () {
            $(this).removeAttr("onkeyup");
            var fn_name = "mc_setinp_i" + str_type;

            window[fn_name]($(this).text());
        });
        $("#" + str_edit_id).attr("mc_edit_type", str_type);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框输入的最大值
   * 参数:
   *    @param { Promise<String> } str_max_val 最大值字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_max_val = function (str_max_val) {
        if ("string" !== typeof str_max_val || "" === str_max_val) {
            return false;
        }
        str_edit_max = str_max_val;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框输入的最大值 操作dom
   * 参数:
   *    @param { Promise<String> } str_max_val 最大值字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_max_val = function (str_max_val) {
        if ("string" !== typeof str_max_val || "" === str_max_val) {
            return false;
        }
        $("#" + str_edit_id).attr("cui_max_val", str_max_val);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框输入的最小值
   * 参数:
   *    @param { Promise<String> } str_min_val 最小值字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_min_val = function (str_min_val) {
        if ("string" !== typeof str_min_val || "" === str_min_val) {
            return false;
        }
        str_edit_min = str_min_val;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框输入的最小值 操作dom
   * 参数:
   *    @param { Promise<String> } str_min_val 最小值字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_min_val = function (str_min_val) {
        if ("string" !== typeof str_min_val || "" === str_min_val) {
            return false;
        }
        $("#" + str_edit_id).attr("cui_min_val", str_min_val);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    禁用编辑框
   * 参数:
   *    @param { Promise<String> } str_disable "false"禁用
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.20
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_disabled = function (str_disable) {
        if ("string" !== typeof str_disable || 0 === str_disable.length) {
            return false;
        }
        if ("false" === str_disable) {
            str_disabled = str_disable;
            ary_style.push(["color", "transparent"], ["text-shadow", "0 0 0 gray"]);
        }
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    禁用编辑框 操作dom
   * 参数:
   *    @param { Promise<String> } str_disable "false"禁用
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.20
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_disabled = function (str_disable) {
        if ("string" !== typeof str_disable || 0 === str_disable.length) {
            return false;
        }
        if ("false" === str_disable) {
            $("#" + str_edit_id).attr("contenteditable", str_disable).addClass("mc_edit_disabled");
        }
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    创建编辑框标签
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     编辑框标签
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_html_txt = function () {
        str_edit_id = "mc_edit" + mc_get_id();
        var str_class_list = "";
        var str_style_list = "";

        for (var idx_class = 0; idx_class < ary_class.length; idx_class++) {
            str_class_list += ary_class[idx_class] + " ";
        }
        str_class_list = str_class_list.trim();

        if (0 !== ary_style.length) {
            for (var idx_style = 0; idx_style < ary_style.length; idx_style++) {
                str_style_list += ary_style[idx_style][0] + ":" + ary_style[idx_style][1] + ";";
            }
            str_style_list = str_style_list.trim();
        }

        // 触发回调函数
        var str_val_chg_callback_attr = "";

        if ("function" === typeof this.on_val_chg) {
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_key(this.on_val_chg) + "'";
        }
        return "<div contenteditable='" + str_disabled + "' " + str_val_chg_callback_attr + " id='" + str_edit_id + "' class='" + str_class_list + "' title = '" + str_edit_title + "' style='" + str_style_list + "' mc_edit_type='" + str_edit_type + "' cui_max_val=" + str_edit_max + " cui_min_val=" + str_edit_min + "  default_digit=" + ui_default_digit + ">" + str_edit_val + "</div>";
    };
}

// 步进编辑框
function mc_ui_step() {
    var str_step_id = "";
    var str_step_val = "0";
    var str_step_title = "";
    var str_step_type = "";
    //默认最大值
    var str_step_max = (Math.pow(2, 32) - 1).toString();
    //默认最小值
    var str_step_min = "-9999";
    //默认步进值
    var str_step = "1";
    // 默认值位数
    var ui_default_digit = 0;
    //[[btnClass],[inpClass]]
    var ary_class = [[], ["mc_step_inp"]];
    //样式[[mc_step_edit_wrap],[inp]]
    var ary_style = [[], []];

    // 数值改变触发 返回当前id与当前值 接受传递函数
    this.on_val_chg = function () {};

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置步进编辑框的样式 宽
   * 参数:
   *    @param { Promise<String> } str_width 宽度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_width = function (str_width) {
        if ("string" !== typeof str_width) {
            return false;
        }
        ary_style[0].push(["width", str_width]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置步进编辑框的样式 宽 操作dom
   * 参数:
   *    @param { Promise<String> } str_width 宽度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_width = function (str_width) {
        if ("string" !== typeof str_width) {
            return false;
        }
        $("#" + str_step_id)
            .parent()
            .css("width", str_width);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置步进编辑框的样式 高
   * 参数:
   *    @param { Promise<String> } str_height 高度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_height = function (str_height) {
        if ("string" !== typeof str_height) {
            return false;
        }
        ary_style[0].push(["height", str_height]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置步进编辑框的样式 高 操作dom
   * 参数:
   *    @param { Promise<String> } str_height 高度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_height = function (str_height) {
        if ("string" !== typeof str_height) {
            return false;
        }
        $("#" + str_step_id).parent().css("height", str_height);
        $("#" + str_step_id).prev().css("line-height", str_height);
        $("#" + str_step_id).next().css("line-height", str_height);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置步进编辑框的样式 字体颜色
   * 参数:
   *    @param { Promise<String> } str_color 颜色
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_color = function (str_color) {
        if ("string" !== typeof str_color) {
            return false;
        }
        ary_style[1].push(["color", str_color]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置步进编辑框的样式 字体颜色 操作dom
   * 参数:
   *    @param { Promise<String> } str_color 颜色
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_color = function (str_color) {
        if ("string" !== typeof str_color) {
            return false;
        }
        $("#" + str_step_id).css("color", str_color);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    步进编辑框inp添加class类
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 添加成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_addinp_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length || "mc_step_inp" === str_css) {
            return false;
        }
        ary_class[1].push(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    步进编辑框inp添加class类 操作dom
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 添加成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_addinp_css = function (str_css) {
        if ("string" !== typeof str_css) {
            return false;
        }
        $("#" + str_step_id).addClass(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    步进编辑框btn添加class类
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 添加成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_addbtn_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length) {
            return false;
        }
        ary_class[0].push(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    步进编辑框btn添加class类 操作dom
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 添加成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_addbtn_css = function (str_css) {
        if ("string" !== typeof str_css) {
            return false;
        }
        $("#" + str_step_id).prev().addClass(str_css);
        $("#" + str_step_id).next().addClass(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    移除步进编辑框inp的class类
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 移除成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_delinp_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length || 0 === ary_style.length || "mc_step_inp" === str_css) {
            return false;
        }
        for (var idx_css = 0; idx_css < ary_class[1].length; idx_css++) {
            if (ary_class[1][idx_css] === str_css) {
                ary_class[1].splice(idx_css, 1);
                break;
            }
        }
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    移除步进编辑框inp的class类 操作dom
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 移除成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_delinp_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length || "mc_step_inp" === str_css) {
            return false;
        }
        $("#" + str_step_id).removeClass(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    移除步进编辑框btn的class类
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 移除成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_delbtn_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length || 0 === ary_style.length) {
            return false;
        }
        for (var idx_css = 0; idx_css < ary_class[0].length; idx_css++) {
            if (ary_class[0][idx_css] === str_css) {
                ary_class[0].splice(idx_css, 1);
                break;
            }
        }
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    移除步进编辑框btn的class类 操作dom
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 移除成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_delbtn_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length) {
            return false;
        }
        $("#" + str_step_id).prev().removeClass(str_css);
        $("#" + str_step_id).next().removeClass(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置步进编辑框的内容
   * 参数:
   *    @param { Promise<String> } str_val 内容字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_val = function (str_val) {
        if ("string" !== typeof str_val || 0 === str_val.length) {
            return false;
        }
        // 效验前位数
        ui_default_digit = str_val.length;
        if ("-" === str_val[0]) {
            ui_default_digit = str_val.length - 1;
        }
        // 设置内容
        str_step_val = mc_edit_val_check(str_val, str_step_type, str_step_min, str_step_max, ui_default_digit);
        // 效验后位数
        ui_default_digit = str_step_val.length;
        if ("-" === str_step_val[0]) {
            ui_default_digit = str_step_val.length - 1;
        }
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置步进编辑框的内容 操作dom
   * 参数:
   *    @param { Promise<String> } str_val 内容字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_val = function (str_val) {
        if ("string" !== typeof str_val || 0 === str_val.length) {
            return false;
        }
        // 数据类型
        var str_val_type = $("#" + str_step_id).attr("mc_step_type");
        // 最大最小值
        var str_val_min = $("#" + str_step_id).prev().attr("cui_min_val");
        var str_val_max = $("#" + str_step_id).next().attr("cui_max_val");
        // 内容位数
        var i_default_digit = str_val.length;

        if ("-" === str_val[0]) {
            i_default_digit -= 1;
        }
        var step_val = mc_edit_val_check(str_val, str_val_type, str_val_min, str_val_max, i_default_digit);

        // 记录位数
        ui_default_digit = step_val.length;

        // 负数去掉符号位
        if ("-" === step_val[0]) {
            ui_default_digit -= 1;
        }
        $("#" + str_step_id).text(step_val).attr("default_digit", ui_default_digit);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    获取步进编辑框的内容
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     步进编辑框内容
   *     null 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_val = function () {
        if (0 === str_step_val.length) {
            return null;
        }
        return str_step_val;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    获取步进编辑框的内容 操作dom
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     步进编辑框的内容
   *     null 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_dom_val = function () {
        if (0 === str_step_val.length) {
            return null;
        }
        return $("#" + str_step_id).text();
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    获取步进编辑框的ID
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     步进编辑框的ID
   *     null 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_id = function () {
        if (0 === str_step_id.length) {
            return null;
        }
        return str_step_id;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    获取步进编辑框的ID 操作dom
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     步进编辑框的ID
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_dom_id = function () {
        return $("#" + str_step_id).attr("id");
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置步进编辑框的title
   * 参数:
   *    @param { Promise<String> } str_title title字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_title = function (str_title) {
        if ("string" !== typeof str_title || 0 === str_title.length) {
            return false;
        }
        str_step_title = str_title;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置步进编辑框的title 操作dom
   * 参数:
   *    @param { Promise<String> } str_title title字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_title = function (str_title) {
        if ("string" !== typeof str_title || 0 === str_title.length) {
            return false;
        }
        $("#" + str_step_id).parent().attr("title", str_title);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置步进编辑框的数据类型 int整数 uint正整数 hex十六进制数 flost浮点数和整数
   * 参数:
   *    @param { Promise<String> } str_type 数据类型
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_type = function (str_type) {
        if ("string" !== typeof str_type || 0 === str_type.length) {
            return false;
        }
        str_step_type = str_type;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置步进编辑框的数据类型 int整数 uint正整数 hex十六进制数 flost浮点数和整数 操作dom
   * 参数:
   *    @param { Promise<String> } str_type 数据类型
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_type = function (str_type) {
        if ("string" !== typeof str_type || 0 === str_type.length) {
            return false;
        }
        $("#" + str_step_id).on("keyup", function () {
            var fn_name = "mc_setinp_i" + str_type;

            window[fn_name]($(this).text());
        });
        $("#" + str_step_id).attr("mc_step_type", str_type);

        // 最大最小值效验
        var str_min_val = $("#" + str_step_id).prev().attr("cui_min_val");
        var str_max_val = $("#" + str_step_id).next().attr("cui_max_val");

        str_min_val = mc_edit_val_check(str_min_val, str_type, 0, 0, ui_default_digit);
        str_max_val = mc_edit_val_check(str_max_val, str_type, 0, 0, ui_default_digit);
        $("#" + str_step_id).prev().attr("cui_min_val", str_min_val);
        $("#" + str_step_id).next().attr("cui_max_val", str_max_val);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置步进编辑框输入的最大值
   * 参数:
   *    @param { Promise<String> } str_max_val 最大值字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_max_val = function (str_max_val) {
        if ("string" !== typeof str_max_val || "" === str_max_val) {
            return false;
        }
        str_step_max = str_max_val;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置步进编辑框输入的最大值 操作dom
   * 参数:
   *    @param { Promise<String> } str_max_val 最大值字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_max_val = function (str_max_val) {
        if ("string" !== typeof str_max_val || "" === str_max_val) {
            return false;
        }
        $("#" + str_step_id).next().attr("cui_max_val", str_max_val);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置步进编辑框输入的最小值
   * 参数:
   *    @param { Promise<String> } str_min_val 最小值
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_min_val = function (str_min_val) {
        if ("string" !== typeof str_min_val || "" === str_min_val) {
            return false;
        }
        str_step_min = str_min_val;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置步进编辑框输入的最小值 操作dom
   * 参数:
   *    @param { Promise<String> } str_min_val 最小值
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_min_val = function (str_min_val) {
        if ("string" !== typeof str_min_val || "" === str_min_val) {
            return false;
        }
        $("#" + str_step_id).prev().attr("cui_min_val", str_min_val);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置步进编辑框的步进值
   * 参数:
   *    @param { Promise<String> } s_step 步进值字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_step_val = function (s_step) {
        if ("string" !== typeof s_step || 0 === s_step.length) {
            return false;
        }
        str_step = s_step;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置步进编辑框的步进值 操作dom
   * 参数:
   *    @param { Promise<String> } s_step 步进值字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_step_val = function (s_step) {
        if ("string" !== typeof s_step || "" === s_step) {
            return false;
        }
        $("#" + str_step_id).attr("cui_step", s_step);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    创建步进编辑框标签
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     步进编辑框标签
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_html_txt = function () {
        str_step_id = "mc_step" + mc_get_id();
        var str_class_list_inp = "";
        var str_class_list_btn = "";
        var str_style_list = "";
        var str_style_inp = "";

        // class类
        for (var idx_class = 0; idx_class < ary_class[1].length; idx_class++) {
            str_class_list_inp += ary_class[1][idx_class] + " ";
        }
        str_class_list_inp = str_class_list_inp.trim();

        if (0 !== ary_class[0].length) {
            for (var idx_class_btn = 0; idx_class_btn < ary_class[0].length; idx_class_btn++) {
                str_class_list_btn += ary_class[0][idx_class_btn] + " ";
            }
            str_class_list_btn = str_class_list_btn.trim();
        }

        // 样式
        if (0 !== ary_style[0].length) {
            for (var idx_style = 0; idx_style < ary_style[0].length; idx_style++) {
                str_style_list += ary_style[0][idx_style][0] + ":" + ary_style[0][idx_style][1] + ";";
            }
            str_style_list = str_style_list.trim();
        }
        if (0 !== ary_style[1].length) {
            for (var idx_style_inp = 0; idx_style_inp < ary_style[1].length; idx_style_inp++) {
                str_style_inp += ary_style[1][idx_style_inp][0] + ":" + ary_style[1][idx_style_inp][1] + ";";
            }
            str_style_inp = str_style_inp.trim();
        }

        // 效验大小值 str_step_max/str_step_min/str_step_type
        if ("" !== str_step_type) {
            str_step_max = mc_edit_val_check(str_step_max, str_step_type, 0, 0, ui_default_digit);
            str_step_min = mc_edit_val_check(str_step_min, str_step_type, 0, 0, ui_default_digit);
        }

        // 接收函数处理
        var str_val_chg_callback_attr = "";

        if ("function" === typeof this.on_val_chg) {
            // on_val_chg = function(){} 接收到的函数作为属性传递
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_key(this.on_val_chg) + "'";
        }
        return "<div class='mc_step_edit_wrap' title='" + str_step_title + "' style='" + str_style_list + "'><div cui_min_val=" + str_step_min + "  class='mc_step_sub icon-arrow-single-left" + " " + str_class_list_btn + "'></div><div contenteditable='true' " + str_val_chg_callback_attr + " id='" + str_step_id + "' class='flex_box_auto_size " + str_class_list_inp + "' style='" + str_style_inp + "' mc_step_type='" + str_step_type + "' cui_step=" + str_step + " default_digit=" + ui_default_digit + ">" + str_step_val + "</div><div class='mc_step_add icon-arrow-single-right" + " " + str_class_list_btn + "' cui_max_val=" + str_step_max + "></div></div>";
    };
}

// 复选框
function mc_ui_checkbox() {
    var str_checkbox_id = "";
    var str_checkbox_title = "";
    var ary_class = [
        ["mc_checkbox_box"],
        ["mc_checkbox_on", "checkbox_flex_box_auto_size"],
        ["mc_checkbox_off", "mc_checkbox_select_btn"]
    ];
    // 复选框 宽高[[mc_checkbox_box],[mc_checkbox_*]]
    var ary_style = [[], []];
    // 复选框选中状态
    var b_default_select = false;
    var str_text_true = "ON";
    var str_text_false = "OFF";

    this.on_val_chg = function () {};

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置复选框样式 宽
   * 参数:
   *    @param { Promise<String> } str_width 宽度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_width = function (str_width) {
        if ("string" !== typeof str_width) {
            return false;
        }
        ary_style[0].push(["width", str_width]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置复选框样式 宽 操作dom
   * 参数:
   *    @param { Promise<String> } str_width 宽度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_width = function (str_width) {
        if ("string" !== typeof str_width) {
            return false;
        }
        $("#" + str_checkbox_id).css("width", str_width);
        mc_checkbox_event("#" + str_checkbox_id);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置复选框样式 高
   * 参数:
   *    @param { Promise<String> } str_height 高度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_height = function (str_height) {
        if ("string" !== typeof str_height) {
            return false;
        }
        ary_style[0].push(["height", str_height]);
        ary_style[1].push(["line-height", str_height]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置复选框样式 高 操作dom
   * 参数:
   *    @param { Promise<String> } str_height 高度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_height = function (str_height) {
        if ("string" !== typeof str_height) {
            return false;
        }
        $("#" + str_checkbox_id).css("height", str_height);
        $("#" + str_checkbox_id)
            .children()
            .eq(0)
            .css("line-height", str_height);
        $("#" + str_checkbox_id)
            .children()
            .eq(1)
            .css("line-height", str_height);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    添加复选框的class类
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 添加成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_add_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length) {
            return false;
        }
        ary_class[0].push(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    添加复选框的class类 操作dom
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 添加成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_add_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length) {
            return false;
        }
        $("#" + str_checkbox_id).addClass(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    移除复选框class类
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 移除成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_del_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length || "mc_checkbox_box" === str_css) {
            return false;
        }
        for (var idx_css = 0; idx_css < ary_class[0].length; idx_css++) {
            if (ary_class[0][idx_css] === str_css) {
                ary_class[0].splice(idx_css, 1);
                break;
            }
        }
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    移除复选框class类 操作dom
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 移除成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_del_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length || "mc_checkbox_box" === str_css) {
            return false;
        }
        $("#" + str_checkbox_id).removeClass(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置复选框的默认值 是否选中 通过控制相关类
   * 参数:
   *    @param { Promise<Boolean> } b_val true/false是否选中
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_val = function (b_val) {
        if ("boolean" !== typeof b_val || 0 === b_val.length) {
            return false;
        }
        b_default_select = b_val;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置复选框的默认值 是否选中 通过控制相关类 操作dom
   * 参数:
   *    @param { Promise<Boolean> } b_val 是否选中
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_val = function (b_val) {
        if ("boolean" !== typeof b_val || 0 === b_val.length) {
            return false;
        }
        if (b_val) {
            $("#" + str_checkbox_id).attr("checkbox_select", "true");
            mc_checkbox_event("#" + str_checkbox_id);
        } else {
            $("#" + str_checkbox_id).attr("checkbox_select", "false");
            mc_checkbox_event("#" + str_checkbox_id);
        }
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    获取复选框ID
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     复选框ID
   *     null 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_id = function () {
        if (0 === str_checkbox_id.length) {
            return null;
        }
        return str_checkbox_id;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    获取复选框ID 操作dom
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     复选框ID
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_dom_id = function () {
        return $("#" + str_checkbox_id).attr("id");
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置复选框title
   * 参数:
   *    @param { Promise<String> } str_title title字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_title = function (str_title) {
        if ("string" !== typeof str_title || 0 === str_title.length) {
            return false;
        }
        str_checkbox_title = str_title;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置复选框title 操作dom
   * 参数:
   *    @param { Promise<String> } str_title title字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_title = function (str_title) {
        if ("string" !== typeof str_title || 0 === str_title.length) {
            return false;
        }
        $("#" + str_checkbox_id).attr("title", str_title);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置提示文字
   * 参数:
   *    @param { Promise<Array> } arr_text 提示文字数组
   * 举例：
   *    ["ON","OFF"]
   * 返回：
   *    @return { Promise<Boolean> }
   *     true  设置成功
   *     false 参数错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_text = function (arr_text) {
        if (!(arr_text instanceof Array) || 0 === arr_text.length) {
            return false;
        }
        str_text_true = arr_text[0];
        str_text_false = arr_text[1];
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置提示文字 操作dom
   * 参数:
   *    @param { Promise<Array> } arr_text 提示文字数组
   * 举例：
   *    ["ON","OFF"]
   * 返回：
   *    @return { Promise<Boolean> }
   *     true  设置成功
   *     false 参数错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_text = function (arr_text) {
        if (!(arr_text instanceof Array) || 0 === arr_text.length) {
            return false;
        }
        $("#" + str_checkbox_id).find("div").eq(0).text(arr_text[0]);
        $("#" + str_checkbox_id).find("div").eq(1).text(arr_text[1]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    创建复选框标签
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     复选框标签
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_html_txt = function () {
        str_checkbox_id = "mc_checkbox" + mc_get_id();
        //复选框class类字串
        var str_class_box_list = "";
        var str_class_on_list = "";
        var str_class_off_list = "";

        var str_style_list = "";
        var str_text_style_list = "";

        for (var idx_box_class = 0; idx_box_class < ary_class[0].length; idx_box_class++) {
            str_class_box_list += ary_class[0][idx_box_class] + " ";
        }
        str_class_box_list = str_class_box_list.trim();

        for (var idx_on_class = 0; idx_on_class < ary_class[1].length; idx_on_class++) {
            str_class_on_list += ary_class[1][idx_on_class] + " ";
        }
        str_class_on_list = str_class_on_list.trim();

        for (var idx_off_class = 0; idx_off_class < ary_class[2].length; idx_off_class++) {
            str_class_off_list += ary_class[2][idx_off_class] + " ";
        }
        str_class_off_list = str_class_off_list.trim();

        if (0 !== ary_style[0].length) {
            for (var idx_style = 0; idx_style < ary_style[0].length; idx_style++) {
                str_style_list += ary_style[0][idx_style][0] + ":" + ary_style[0][idx_style][1] + ";";
            }
            str_style_list = str_style_list.trim();
        }

        if (0 !== ary_style[1].length) {
            for (var idx_text_style = 0; idx_text_style < ary_style[1].length; idx_text_style++) {
                str_text_style_list += ary_style[1][idx_text_style][0] + ":" + ary_style[1][idx_text_style][1] + ";";
            }
            str_text_style_list = str_text_style_list.trim();
        }

        // 触发回调函数
        var str_val_chg_callback_attr = "";

        if ("function" === typeof this.on_val_chg) {
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_key(this.on_val_chg) + "'";
        }
        return "<div class='" + str_class_box_list + "' id='" + str_checkbox_id + "' " + str_val_chg_callback_attr + "  style='" + str_style_list + "' title='" + str_checkbox_title + "' checkbox_select=" + b_default_select + "><div class='" + str_class_on_list + "' style='" + str_text_style_list + "'>" + str_text_true + "</div><div class='" + str_class_off_list + "' style='" + str_text_style_list + "'>" + str_text_false + "</div></div>";
    };
}

// 滑动条
function mc_ui_slider() {
    var str_slider_id = "";
    var str_slider_title = "";
    var str_slider_max = "100";
    var str_slider_min = "0";
    var str_slider_step = "1";
    // 滑块默认值
    var str_slider_val = "50";

    //[[轨道],[div滑块]]
    var ary_class = [["mc_slider"], ["mc_slider_thumb"]];
    //[[轨道样式],[div滑块样式]]
    var ary_style = [[], []];

    // 数值改变触发 返回当前id与当前值 接受传递函数
    this.on_val_chg = function () {};

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置滑动条样式 宽
   * 参数:
   *    @param { Promise<String> } str_width 宽度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_width = function (str_width) {
        if ("string" !== typeof str_width) {
            return false;
        }
        ary_style[0].push(["width", str_width]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置滑动条样式 宽 操作dom
   * 参数:
   *    @param { Promise<String> } str_width 宽度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_width = function (str_width) {
        if ("string" !== typeof str_width) {
            return false;
        }
        $("#" + str_slider_id).css("width", str_width);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置滑动条样式 高
   * 参数:
   *    @param { Promise<String> } str_height 高度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_height = function (str_height) {
        if ("string" !== typeof str_height) {
            return false;
        }
        ary_style[0].push(["height", str_height]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置滑动条样式 高 操作dom
   * 参数:
   *    @param { Promise<String> } str_height 高度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_height = function (str_height) {
        if ("string" !== typeof str_height) {
            return false;
        }
        $("#" + str_slider_id).css("height", str_height);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置滑动条样式 背景颜色
   * 参数:
   *    @param { Promise<String> } str_color 背景颜色
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_color = function (str_color) {
        if ("string" !== typeof str_color) {
            return false;
        }
        ary_style[0].push(["background-color", str_color]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置滑动条样式 背景颜色 操作dom
   * 参数:
   *    @param { Promise<String> } str_color 背景颜色
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_color = function (str_color) {
        if ("string" !== typeof str_color) {
            return false;
        }
        $("#" + str_slider_id).css("background-color", str_color);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置滑动条滑块样式 显示值颜色
   * 参数:
   *    @param { Promise<String> } str_color 显示值颜色
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_thumb_color = function (str_color) {
        if ("string" !== typeof str_color) {
            return false;
        }
        ary_style[1].push(["color", str_color]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置滑动条滑块样式 显示值颜色 操作dom
   * 参数:
   *    @param { Promise<String> } str_color 显示值颜色
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_thumb_color = function (str_color) {
        if ("string" !== typeof str_color) {
            return false;
        }
        $("#" + str_slider_id)
            .find("div")
            .eq(2)
            .css("color", str_color);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    滑动条轨道添加class类
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 添加成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_add_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length) {
            return false;
        }
        ary_class[0].push(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    滑动条轨道添加class类 操作dom
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 添加成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_add_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length) {
            return false;
        }
        $("#" + str_slider_id).addClass(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    滑动条轨道移除class类
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 移除成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_del_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length || 0 === ary_class[0].length || "mc_slider" === str_css) {
            return false;
        }
        for (var idx_css = 0; idx_css < ary_class.length; idx_css++) {
            if (ary_class[0][idx_css] === str_css) {
                ary_class[0].splice(idx_css, 1);
                break;
            }
        }
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    滑动条轨道移除class类 操作dom
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 移除成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_del_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length || "mc_slider" === str_css) {
            return false;
        }
        $("#" + str_slider_id).removeClass(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    滑动条滑块添加class类
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 添加成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_add_dcss = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length) {
            return false;
        }
        ary_class[1].push(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    滑动条滑块添加class类 操作dom
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 添加成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_add_dcss = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length) {
            return false;
        }
        $("#" + str_slider_id)
            .find("div")
            .eq(2)
            .addClass(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    滑动条滑块移除class类
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 移除成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_del_dcss = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length || 0 === ary_class[1].length || "mc_slider_thumb" === str_css) {
            return false;
        }
        for (var idx_css = 0; idx_css < ary_class.length; idx_css++) {
            if (ary_class[1][idx_css] === str_css) {
                ary_class[1].splice(idx_css, 1);
                break;
            }
        }
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    滑动条滑块移除class类 操作dom
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 移除成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_del_dcss = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length || "mc_slider_thumb" === str_css) {
            return false;
        }
        $("#" + str_slider_id).find("div").eq(2).removeClass(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置滑动条轨道默认位置 设置其left样式
   * 参数:
   *    @param { Promise<String> } str_val 位置字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_val = function (str_val) {
        if ("string" !== typeof str_val || 0 === str_val.length) {
            return false;
        }
        var i_max = parseFloat(str_slider_max);
        var i_min = parseFloat(str_slider_min);
        var i_val = parseFloat(str_val);
        var i_step = parseFloat(str_slider_step);

        i_val = Math.round(i_val / i_step) * i_step;
        if (i_max < i_val) {
            i_val = i_max;
        }
        if (i_min > i_val) {
            i_val = i_min;
        }
        var i_thumb_val = i_val * (100 / (i_max - i_min)) - i_min + 1;

        if (0 > i_thumb_val) {
            i_thumb_val = 0;
        }
        ary_style[1].push(["left", i_thumb_val + "%"]);
        str_slider_val = i_val;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置滑动条轨道默认位置 设置其left样式 操作dom
   * 参数:
   *    @param { Promise<String> } str_val 位置字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_val = function (str_val) {
        if ("string" !== typeof str_val || 0 === str_val.length) {
            return false;
        }
        var o_thumb = $("#" + str_slider_id).find("div").eq(2);
        var i_max = parseFloat($("#" + str_slider_id).find("div").eq(1).html());
        var i_min = parseFloat($("#" + str_slider_id).find("div").eq(0).html());
        var i_step = parseFloat(o_thumb.attr("cui_step"));
        var i_max_left = $("#" + str_slider_id).width() - 2 - o_thumb.width();
        // 总格数
        var i_grid_cnt = Math.round((i_max - i_min) / i_step);
        // 每格像素
        var i_grid_pix = i_max_left / i_grid_cnt;
        var i_val = parseFloat(str_val);

        if (i_max < i_val) {
            i_val = i_max;
        }
        if (i_min > i_val) {
            i_val = i_min;
        }

        // 移动格数
        var i_grid_idx = Math.round((i_val - i_min) / i_step);
        // 移动像素
        var ui_curr_left = i_grid_idx * i_grid_pix;

        o_thumb.css("left", ui_curr_left + "px").attr("default_val", i_val);
        mc_slider_event(o_thumb);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    获取滑动条ID
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     滑动条ID
   *     null 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_id = function () {
        if (0 === str_slider_id.length) {
            return null;
        }
        return str_slider_id;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    获取滑动条ID 操作dom
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     滑动条ID
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_dom_id = function () {
        return $("#" + str_slider_id).attr("id");
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置滑动条title
   * 参数:
   *    @param { Promise<String> } str_title title字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_title = function (str_title) {
        if ("string" !== typeof str_title || 0 === str_title.length) {
            return false;
        }
        str_slider_title = str_title;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置滑动条title 操作dom
   * 参数:
   *    @param { Promise<String> } str_title title字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_title = function (str_title) {
        if ("string" !== typeof str_title || 0 === str_title.length) {
            return false;
        }
        $("#" + str_slider_id).attr("title", str_title);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置滑动条数据的最大值
   * 参数:
   *    @param { Promise<String> } str_max_val 最大值字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_max_val = function (str_max_val) {
        if ("string" !== typeof str_max_val || "" === str_max_val) {
            return false;
        }
        str_slider_max = str_max_val;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置滑动条数据的最大值 操作dom
   * 参数:
   *    @param { Promise<String> } str_max_val 最大值字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_max_val = function (str_max_val) {
        if ("string" !== typeof str_max_val || "" === str_max_val) {
            return false;
        }
        $("#" + str_slider_id).find("div").eq(1).html(str_max_val);
        mc_slider_event($("#" + str_slider_id).find("div").eq(2));
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置滑动条数据的最小值
   * 参数:
   *    @param { Promise<String> } str_min_val 最小值字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_min_val = function (str_min_val) {
        if ("string" !== typeof str_min_val || "" === str_min_val) {
            return false;
        }
        str_slider_min = str_min_val;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置滑动条数据的最小值 操作dom
   * 参数:
   *    @param { Promise<String> } str_min_val 最小值字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_min_val = function (str_min_val) {
        if ("string" !== typeof str_min_val || "" === str_min_val) {
            return false;
        }
        $("#" + str_slider_id).find("div").eq(0).html(str_min_val);
        mc_slider_event($("#" + str_slider_id).find("div").eq(2));
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置滑动条的步进值
   * 参数:
   *    @param { Promise<String> } str_step_val 步进值
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.11
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_step_val = function (str_step_val) {
        if ("string" !== typeof str_step_val || "" === str_step_val) {
            return false;
        }
        str_slider_step = str_step_val;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置滑动条的步进值 操作dom
   * 参数:
   *    @param { Promise<String> } str_step_val 步进值
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.11
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_step_val = function (str_step_val) {
        if ("string" !== typeof str_step_val || "" === str_step_val) {
            return false;
        }
        $("#" + str_slider_id).find("div").eq(2).attr("cui_step", str_step_val);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    创建滑动条标签
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     滑动条标签
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_html_txt = function () {
        str_slider_id = "mc_slider" + mc_get_id();
        // 轨道 div滑块 class类
        var str_class_list_slider = "";
        var str_class_list_dthumb = "";
        var str_style_list_thumb = "";
        var str_style_list = "";

        for (var idx_class_slider = 0; idx_class_slider < ary_class[0].length; idx_class_slider++) {
            str_class_list_slider += ary_class[0][idx_class_slider] + " ";
        }

        for (var idx_class_dthumb = 0; idx_class_dthumb < ary_class[1].length; idx_class_dthumb++) {
            str_class_list_dthumb += ary_class[1][idx_class_dthumb] + " ";
        }
        str_class_list_slider = str_class_list_slider.trim();
        str_class_list_dthumb = str_class_list_dthumb.trim();

        // 样式
        if (0 !== ary_style[0].length) {
            for (var idx_style = 0; idx_style < ary_style[0].length; idx_style++) {
                str_style_list += ary_style[0][idx_style][0] + ":" + ary_style[0][idx_style][1] + ";";
            }
            str_style_list = str_style_list.trim();
        }

        if (0 !== ary_style[1].length) {
            for (var idx_style_thumb = 0; idx_style_thumb < ary_style[1].length; idx_style_thumb++) {
                str_style_list_thumb += ary_style[1][idx_style_thumb][0] + ":" + ary_style[1][idx_style_thumb][1] + ";";
            }
            str_style_list_thumb = str_style_list_thumb.trim();
        }

        // 触发回调函数
        var str_val_chg_callback_attr = "";

        if ("function" === typeof this.on_val_chg) {
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_key(this.on_val_chg) + "'";
        }
        return (
            "<div id='" + str_slider_id + "' class='" + str_class_list_slider + "' title='" + str_slider_title + "' style='" + str_style_list +
      "'><div class='mc_slider_min'>" + str_slider_min +
      "</div><div class='mc_slider_max'>" + str_slider_max +
      "</div><div " + str_val_chg_callback_attr + " class='" + str_class_list_dthumb + "' style='" + str_style_list_thumb + "' cui_step='" + str_slider_step + "' default_val='" + str_slider_val + "'></div></div>"
        );
    };
}

// 下拉列表框
function mc_ui_select() {
    var str_select_id = "";
    //下拉列表值
    var arr_select_val = [];
    var str_select_title = "";
    var ary_style = [];
    // 默认值 未设置默认第一个
    var str_default_val = "";
    var ary_class = ["mc_opt_select"];
    //样式通过添加类来修改 输入框宽高 下拉菜单背景颜色、字体大小 修
    // var ary_style = [[], []];
    // 分类列表分类头
    var arr_select_classify_title = [ "ABCDE", "FGHIJ", "KLMNO", "PQRST", "UVWXYZ", "其他" ];
    // 分类下拉列表是否隐藏
    var b_is_classify = true;
    // 输入框是否可编辑
    var b_is_edit = true;

    this.on_val_chg = function () {};

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置下拉列表的样式 宽
   * 参数:
   *     @param { Promise<String> } str_width 宽度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.03.10
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_width = function (str_width) {
        if ("string" !== typeof str_width) {
            return false;
        }
        // 判断是替换还是增加
        var b_add = true;

        for (var idx_style = 0; idx_style < ary_style.length; idx_style++) {
            var arr_item_style = ary_style[idx_style];

            if ("width" === arr_item_style[0]) {
                arr_item_style[1] = str_width;
                b_add = false;
            }
        }
        if (b_add) {
            ary_style.push(["width", str_width]);
        }
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置下拉列表的样式 高
   * 参数:
   *     @param { Promise<String> } str_height 高度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.03.10
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_height = function (str_height) {
        if ("string" !== typeof str_height) {
            return false;
        }
        // 判断是替换还是增加
        var b_add = true;
        var b_add_lineh = true;

        for (var idx_style = 0; idx_style < ary_style.length; idx_style++) {
            var arr_item_style = ary_style[idx_style];

            if ("height" === arr_item_style[0]) {
                arr_item_style[1] = str_height;
                b_add = false;
            }
            if ("line-height" === arr_item_style[0]) {
                arr_item_style[1] = str_height;
                b_add_lineh = false;
            }
        }
        if (b_add) {
            ary_style.push(["height", str_height]);
        }
        if (b_add_lineh) {
            ary_style.push(["line-height", str_height]);
        }
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    处理下拉列表值为指定格式分类列表数据
     * 参数:
     *    @param { Promise<Array> } arr_val 下拉列表值
     *    @param { Promise<Array> } arr_title  分类列表分类头值
     * 返回：
     *    @return { Promise<Object> }
     *     {} 参数错误
     *     obj_cont 分类列表数据
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2020.02.19
     *      内容 : 所有代码
     ************************************************************************************************/
    function set_select_classify_data(arr_val, arr_title) {
        if (!(arr_val instanceof Array) || 0 === arr_val.length || !(arr_title instanceof Array) || 0 === arr_title.length) {
            return {};
        }
        var arr_val_copy = [];
        var arr_title_copy = [];

        arr_val_copy = $.extend(true, [], arr_val);
        arr_title_copy = $.extend(true, [], arr_title);

        // var arr_title = ["ABCDE", "FGHIJ", "KLMNO", "PQRST", "UVWXYZ", "其他"];
        // { "ABCDE": { "A": [], "B": [], "C": [] }, "FGHIJ": { "F": [], "G": [], "H": [] },"其他":[] };
        var obj_cont = {};
        // { "A": [], "B": [], "C": [] }
        var obj_cont_item = {};
        // 匹配含中文
        var reg_judge = /^[a-zA-Z_]$/;
        var arr_cont_item = [];

        for (var idx_char = 0; 26 >= idx_char; idx_char++) {
            var str_upper = String.fromCharCode(65 + idx_char);
            var str_lower = str_upper.toLowerCase();

            arr_cont_item = [];

            // 匹配开头字母分类
            for (var idx_val = 0; idx_val < arr_val_copy.length; idx_val++) {
                var str_item = arr_val_copy[idx_val];
                var str_item_val = arr_val_copy[idx_val];

                // 数据格式为 val=txt 判断
                if ("string" === typeof str_item) {
                    var i_gap_pos = str_item.indexOf("=");

                    if (1 <= i_gap_pos) {
                        str_item = str_item.substr(i_gap_pos + 1);
                    }
                    str_item = str_item.trim();
                }
                if (str_upper === str_item.charAt(0) || str_lower === str_item.charAt(0)) {
                    arr_cont_item.push(str_item_val);
                    obj_cont_item[str_upper] = arr_cont_item;
                    // 将匹配项从拷贝数组中删除
                    arr_val_copy.splice(idx_val,1);
                    idx_val--;
                }
            }

            // 匹配类型 如ABCDE
            for (var idx_title = 0; idx_title < arr_title_copy.length; idx_title++) {
                var str_title = arr_title_copy[idx_title];

                if (-1 !== str_title.indexOf(str_upper) && 0 !== arr_cont_item.length) {
                    obj_cont[str_title] = obj_cont_item;
                    // 将匹配项从拷贝数组中删除
                    arr_title_copy.splice(idx_title,1);
                    idx_title--;
                }
            }
            if (0 === (idx_char + 1) % 5) {
                obj_cont_item = {};
            }
        }
        // 含中文 -> 其他
        for (var idx_chinese = 0; idx_chinese < arr_val_copy.length; idx_chinese++) {
            var str_item_c = arr_val_copy[idx_chinese];
            var str_item_cval = arr_val_copy[idx_chinese];

            // 数据格式为 val=txt 判断
            if ("string" === typeof str_item_c) {
                var i_gap_pos_zh = str_item_c.indexOf("=");

                if (1 <= i_gap_pos_zh) {
                    str_item_c = str_item_c.substr(i_gap_pos_zh + 1);
                }
                str_item_c = str_item_c.trim();
            }
            if (!reg_judge.test(str_item_c[0])) {
                var str_other_title = arr_title_copy[arr_title_copy.length - 1];

                arr_cont_item.push(str_item_cval);
                obj_cont[str_other_title] = arr_cont_item;
            }
        }
        return obj_cont;
    }

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    创建分类列表标签字串
     * 参数:
     *    @param { Promise<Object> } obj_classify_data 分类列表数据
     * 返回：
     *    @return { Promise<String> }
     *     "" 参数错误
     *     分类列表标签字串
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2020.02.19
     *      内容 : 所有代码
     ************************************************************************************************/
    function get_str_select_classify(obj_classify_data) {
        if ("object" !== typeof obj_classify_data) {
            return "";
        }
        // 分类下拉列表头部数据
        var arr_search_title = [];

        // **
        if (!Object.keys) {
            // eslint-disable-next-line no-shadow
            Object.keys = function (obj_classify_data) {
                if (obj_classify_data !== Object(obj_classify_data)) {
                    throw new TypeError("Object.keys called on a non-object");
                }
                for (var p in obj_classify_data) {
                    if (Object.prototype.hasOwnProperty.call(obj_classify_data,p)) {
                        arr_search_title.push(p);
                    }
                }
            };
        } else {
            arr_search_title = Object.keys(obj_classify_data);
        }
        // Object.keys(obj)兼容
        // if (!Object.keys) {
        //     Object.keys = function (obj_classify_data) {
        //         for (var k in obj_classify_data) {
        //             if (obj_classify_data.hasOwnProperty(k)) {
        //                 arr_search_title.push(obj_classify_data[k]);
        //             }
        //         }
        //     };
        // } else {
        //     arr_search_title = Object.keys(obj_classify_data);
        // }
        // **

        var str_search_title_chi = "";
        // 分类列表左侧分类
        var str_sc_cont_left = "";
        var str_sc_cont_right = "";
        // 分类下拉列表内容标签
        var str_search_cont = "";
        // 分类列表头部宽度
        var str_sc_search_title_chi_w = (100 / arr_search_title.length) + "%";

        for ( var idx_title = 0; idx_title < arr_search_title.length; idx_title++) {
        // "ABCDE"
            var str_search_title_item = arr_search_title[idx_title];

            if (0 === idx_title) {
            // 第一项高亮
                str_search_title_chi = "<li sc_index='" + idx_title + "' class='sc_title_active' style='width:" + str_sc_search_title_chi_w + ";'>" + str_search_title_item + " </li>";
            } else {
                str_search_title_chi += "<li sc_index='" + idx_title + "' style='width:" + str_sc_search_title_chi_w + ";'>" + str_search_title_item + " </li>";
            }

            // 分类列表内容数据
            var obj_search_cont = obj_classify_data[str_search_title_item];
            var arr_cont_left = [];
            var str_sc_cont_left_chi = "";
            var str_sc_cont_right_chi = "";
            var str_cont_right_chi = "";

            if (obj_search_cont instanceof Array) {
                // 其他部分无左侧分类 另外处理
                var arr_search_cont = obj_search_cont;

                str_sc_cont_left_chi = "";
                for (var idx_other = 0; idx_other < arr_search_cont.length; idx_other++) {
                    var str_other_val = arr_search_cont[idx_other];
                    var str_other_txt = str_other_val;

                    if ("string" === typeof str_other_val) {
                        var i_gap_pos_other = str_other_val.indexOf("=");

                        if (1 <= i_gap_pos_other) {
                            str_other_val = str_other_val.substr(0, i_gap_pos_other);
                            str_other_txt = str_other_txt.substr(i_gap_pos_other + 1);
                        }
                        str_other_val = str_other_val.trim();
                        str_other_txt = str_other_txt.trim();
                        if (0 === str_other_txt.length) {
                            str_other_txt = str_other_val;
                        }
                    }
                    str_cont_right_chi += "<li value='" + str_other_val + "'>" + str_other_txt + "</li>";
                }
                str_sc_cont_right_chi = "<ul class='sc_cont_list'> " + str_cont_right_chi + " </ul>";
            } else if (!Object.keys) {
                // Object.keys = function (obj_search_cont) {
                //     for (var k in obj_search_cont) {
                //         if (obj_search_cont.hasOwnProperty(k)) {
                //             arr_cont_left.push(obj_search_cont[k]);
                //         }
                //     }
                // };
                // eslint-disable-next-line no-shadow
                Object.keys = function (obj_search_cont) {
                    if (obj_search_cont !== Object(obj_search_cont)) {
                        throw new TypeError("Object.keys called on a non-object");
                    }
                    for (var p in obj_search_cont) {
                        if (Object.prototype.hasOwnProperty.call(obj_search_cont,p)) {
                            arr_search_title.push(p);
                        }
                    }
                };
            } else {
                arr_cont_left = Object.keys(obj_search_cont);
            }

            if (0 !== arr_cont_left.length) {
                for (var idx_cont_left = 0; idx_cont_left < arr_cont_left.length; idx_cont_left++) {
                    var str_cont_title = arr_cont_left[idx_cont_left];

                    str_sc_cont_left_chi += "<p>" + str_cont_title + "</p>";
                    // 分类列表内容右侧数据
                    var arr_cont_right = obj_search_cont[str_cont_title];

                    str_cont_right_chi = "";
                    for (var idx_cont_rigth = 0; idx_cont_rigth < arr_cont_right.length; idx_cont_rigth++) {
                        var str_val = arr_cont_right[idx_cont_rigth];
                        var str_txt = str_val;

                        if ("string" === typeof str_val) {
                            var i_gap_pos = str_val.indexOf("=");

                            if (1 <= i_gap_pos) {
                                str_val = str_val.substr(0, i_gap_pos);
                                str_txt = str_txt.substr(i_gap_pos + 1);
                            }
                            str_val = str_val.trim();
                            str_txt = str_txt.trim();
                            if (0 === str_txt.length) {
                                str_txt = str_val;
                            }
                        }
                        str_cont_right_chi += "<li value='" + str_val + "'>" + str_txt + "</li>";
                    }
                    str_sc_cont_right_chi += "<ul class='sc_cont_list'> " + str_cont_right_chi + " </ul>";
                }
            }
            if ("" === str_sc_cont_left_chi) {
                str_sc_cont_left = "";
            } else {
                str_sc_cont_left = "<div class='sc_cont_left'> " + str_sc_cont_left_chi + " </div>";
            }

            str_sc_cont_right = "<div class='sc_cont_right'> " + str_sc_cont_right_chi + " </div>";
            str_search_cont += "<div class='sc_search_cont" + idx_title + "' style='display:none;'> " + str_sc_cont_left + " " + str_sc_cont_right + " </div>";
        }
        // 关闭标签
        var str_sc_heard = "<div class='sc_heard'><span></span><span style='padding-right: 6px;'>&times;</span></div>";
        // 分类下拉列表头部标签
        var str_search_title = "<ul class='sc_search_title'> " + str_search_title_chi + " </ul>";
        // 尾部换页标签
        var str_sc_flip = "<div class='sc_flip'><span class='sc_flip_prev'>上一页</span><i>|</i><span class='sc_flip_next'>下一页</span></div>";
        // 分类下拉列表
        var str_select_classify = str_sc_heard + " " + str_search_title + " " + str_search_cont + " " + str_sc_flip;

        return str_select_classify;
    }

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    循环下拉列表值创建列表字串
     * 参数:
     *    @param { Promise<Array> } ary_pairs 下拉列表值
     * 返回：
     *    @return { Promise<String> }
     *     "" 参数错误
     *     str_val_list 下拉列表字串
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2020.02.19
     *      内容 : 所有代码
     ************************************************************************************************/
    function format_option_html_by_ary(ary_pairs) {
        if (!(ary_pairs instanceof Array)) {
            return "";
        }

        var str_val_list = "";

        for (var idx_val = 0; idx_val < ary_pairs.length; idx_val++) {
            var str_val = ary_pairs[idx_val];
            var str_txt = str_val;

            if ("string" === typeof str_val) {
                var i_gap_pos = str_val.indexOf("=");

                if (1 <= i_gap_pos) {
                    str_val = str_val.substr(0, i_gap_pos);
                    str_txt = str_txt.substr(i_gap_pos + 1);
                }
                str_val = str_val.trim();
                str_txt = str_txt.trim();
                if (0 === str_txt.length) {
                    str_txt = str_val;
                }
            }
            str_val_list += "<li value='" + str_val + "'>" + str_txt + "</li>";
        }

        return str_val_list;
    }

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置下拉列表框的内容
     * 参数:
     *    @param { Promise<Array> } arr_val 内容数组
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2020.02.19
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_arr = function (arr_val) {
        if (!(arr_val instanceof Array) || 0 === arr_val.length) {
            return false;
        }
        // 未设置默认值则为第一个
        if (0 === str_default_val.length) {
            var str_text = arr_val[0];

            if ("string" === typeof str_text) {
                var i_gap_pos = str_text.indexOf("=");

                if (1 <= i_gap_pos) {
                    str_text = str_text.substr(i_gap_pos + 1);
                }
                str_text = str_text.trim();
            }
            str_default_val = str_text;
        }
        arr_select_val = arr_val;
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置下拉列表框的内容 操作dom
     * 参数:
     *    @param { Promise<Array> } arr_val 内容数组
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2020.02.19
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_dom_arr = function (arr_val) {
        if (!(arr_val instanceof Array) || 0 === arr_val.length) {
            return false;
        }
        var str_val_list = format_option_html_by_ary(arr_val);
        var obj_select_classify_data = set_select_classify_data(arr_val,arr_select_classify_title);
        var str_select_classify = get_str_select_classify(obj_select_classify_data);

        // 下拉列表
        $("#" + str_select_id).children().eq(1).html(str_val_list);
        // 分类列表
        $("#" + str_select_id).children().eq(2).html(str_select_classify);
        arr_select_val = arr_val;
        // 设置默认值为第一项
        str_default_val = arr_val[0];
        if ("string" === typeof str_default_val) {
            var i_gap_pos = str_default_val.indexOf("=");

            if (1 <= i_gap_pos) {
                str_default_val = str_default_val.substr(i_gap_pos + 1);
            }
            str_default_val = str_default_val.trim();
        }

        $("#" + str_select_id).attr("mc_select_default", str_default_val).children().eq(0).children().eq(0).text(str_default_val);
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置分类列表表头
     * 参数:
     *    @param { Promise<Array> } arr_title 分类列表表头数据数组
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2020.02.19
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_classify_title = function (arr_title) {
        if (!(arr_title instanceof Array) || 0 === arr_title.length ) {
            return false;
        }
        arr_select_classify_title = arr_title;
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    获取下拉列表框ID
     * 参数:
     *    无
     * 返回：
     *    @return { Promise<String> }
     *     下拉列表框ID
     *     null 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2020.02.19
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_id = function () {
        if (0 === str_select_id.length) {
            return null;
        }
        return str_select_id;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    获取下拉列表框ID 操作dom
     * 参数:
     *    无
     * 返回：
     *    @return { Promise<String> }
     *     下拉列表框ID
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2020.02.19
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_dom_id = function () {
        return $("#" + str_select_id).attr("id");
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置下拉列表框的title
     * 参数:
     *    @param { Promise<String> } str_title title字串
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2020.02.19
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_title = function (str_title) {
        if ("string" !== typeof str_title || 0 === str_title.length) {
            return false;
        }
        str_select_title = str_title;
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置下拉列表框的title 操作dom
     * 参数:
     *    @param { Promise<String> } str_title title字串
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2020.02.19
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_dom_title = function (str_title) {
        if ("string" !== typeof str_title || 0 === str_title.length) {
            return false;
        }
        $("#" + str_select_id).attr("title", str_title);
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置下拉列表框的默认值
     * 参数:
     *    @param { Promise<String> } str_default 默认值字串 key
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2020.02.19
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_val = function (str_default) {
        if ("string" !== typeof str_default || 0 === str_default.length) {
            return false;
        }
        for (var idx_val = 0; idx_val < arr_select_val.length; idx_val++) {
            var str_val = arr_select_val[idx_val];
            var str_txt = str_val;

            if ("string" === typeof str_val) {
                var i_gap_pos = str_val.indexOf("=");

                if (1 <= i_gap_pos) {
                    str_val = str_val.substr(0,i_gap_pos);
                    str_txt = str_txt.substr(i_gap_pos + 1);
                }
                str_val = str_val.trim();
                str_txt = str_txt.trim();
                if (0 === str_txt.length) {
                    str_txt = str_val;
                }
                if (str_default === str_val) {
                    str_default_val = str_txt;
                    return true;
                }
            }
        }
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置下拉列表框的默认值 操作dom
     * 参数:
     *    @param { Promise<String> } str_default 默认值字串 kay
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2020.02.19
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_dom_val = function (str_default) {
        if ("string" !== typeof str_default || 0 === str_default.length) {
            return false;
        }
        // key匹配value
        for (var idx_val = 0; idx_val < arr_select_val.length; idx_val++) {
            var str_val = arr_select_val[idx_val];
            var str_txt = str_val;

            if ("string" === typeof str_val) {
                var i_gap_pos = str_val.indexOf("=");

                if (1 <= i_gap_pos) {
                    str_val = str_val.substr(0,i_gap_pos);
                    str_txt = str_txt.substr(i_gap_pos + 1);
                }
                str_val = str_val.trim();
                str_txt = str_txt.trim();
                if (0 === str_txt.length) {
                    str_txt = str_val;
                }
                if (str_default === str_val) {
                    str_default_val = str_txt;
                }
            }
        }
        $("#" + str_select_id).attr("mc_select_default", str_default_val).children().eq(0).children().eq(0).text(str_default_val);
        mc_select_event(".mc_opt_select");
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    分类下拉列表是否隐藏
     * 参数:
     *    @param { Promise<Boolean> } b_is_true 是否隐藏
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数有误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2020.03.07
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_is_add_classify = function (b_is_true) {
        if ("boolean" !== typeof b_is_true) {
            return false;
        }
        b_is_classify = b_is_true;
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    输入框是否可编辑
     * 参数:
     *    @param { Promise<Boolean> } b_is_true 是否可编辑
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数有误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2020.03.07
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_is_input_edit = function (b_is_true) {
        if ("boolean" !== typeof b_is_true) {
            return false;
        }
        b_is_edit = b_is_true;
        return true;
    };
    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    创建下拉列表框标签
     * 参数:
     *    无
     * 返回：
     *    @return { Promise<String> }
     *     下拉列表框标签
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2020.02.19
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_html_txt = function () {
        str_select_id = "mc_option" + mc_get_id();
        var str_class_list = "";
        var str_style_list = "";

        for (var idx_class = 0; idx_class < ary_class.length; idx_class++) {
            str_class_list += ary_class[idx_class] + " ";
        }
        str_class_list = str_class_list.trim();
        if (0 !== ary_style.length) {
            for (var idx_style = 0; idx_style < ary_style.length; idx_style++) {
                str_style_list += ary_style[idx_style][0] + ":" + ary_style[idx_style][1] + ";";
            }
            str_style_list = str_style_list.trim();
        }

        // 创建输入框部分
        var str_input = "<div class='select_text'><div class='select_txt' contenteditable=" + b_is_edit + " tabindex='-1' is_edit=" + b_is_edit + ">" + str_default_val + "</div><div class='select_btn_box'><div class='select_btn'></div></div></div>";
        // 下拉列表部分
        var str_val_list = format_option_html_by_ary(arr_select_val);
        var str_select_list = "<ul class='select_list'>" + str_val_list + "</ul>";
        // 分类列表部分
        var str_select_classify = "";

        var obj_select_classify_data = set_select_classify_data(arr_select_val,arr_select_classify_title);

        str_select_classify = get_str_select_classify(obj_select_classify_data);
        if (b_is_classify) {
            str_select_classify = "<div class='select_classify' b_is_none = 'false'>" + str_select_classify + "</div>";
        } else {
            str_select_classify = "<div class='select_classify' style='display:none' b_is_none = 'true'>" + str_select_classify + "</div>";
        }

        // 触发回调函数
        var str_val_chg_callback_attr = "";

        if ("function" === typeof this.on_val_chg) {
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_key(this.on_val_chg) + "'";
        }
        return (
            "<div id='" + str_select_id + "' class='" + str_class_list + "' title='" + str_select_title + "' style='" + str_style_list + "' mc_select_default='" + str_default_val + "' " + str_val_chg_callback_attr + "> " + str_input + " " + str_select_list + " " + str_select_classify + "</div>"
        );
    };
}


// 单选按钮组
function mc_ui_radio() {
    var str_radio_id = "";
    var str_radio_title = "";
    var str_radio_val = [];
    // 整体样式 如宽高
    var ary_style = [];
    var ary_class = ["mc_radio_btn"];
    // 默认选中项val
    var str_default_val = "";

    this.on_val_chg = function () {};

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置单选按钮组的宽度
   * 参数:
   *    @param { Promise<String> } str_width 宽度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.20
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_width = function (str_width) {
        if ("string" !== typeof str_width || 0 === str_width.length) {
            return false;
        }
        ary_style.push(["width", str_width]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置单选按钮组的宽度 操作dom
   * 参数:
   *    @param { Promise<String> } str_width 宽度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.20
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_width = function (str_width) {
        if ("string" !== typeof str_width || 0 === str_width.length) {
            return false;
        }
        $("#" + str_radio_id).css("width", str_width);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置单选按钮组的高度
   * 参数:
   *    @param { Promise<String> } str_heigth 高度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.20
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_height = function (str_heigth) {
        if ("string" !== typeof str_heigth || 0 === str_heigth.length) {
            return false;
        }
        ary_style.push(["height", str_heigth], ["line-height", str_heigth]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置单选按钮组的高度 操作dom
   * 参数:
   *    @param { Promise<String> } str_heigth 高度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.20
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_height = function (str_heigth) {
        if ("string" !== typeof str_heigth || 0 === str_heigth.length) {
            return false;
        }
        $("#" + str_radio_id).css({
            height: str_heigth,
            "line-height": str_heigth
        });
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    添加单选按钮组的calss类
   * 参数:
   *    @param { Promise<String> } str_css calss类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 添加成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.20
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_add_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length) {
            return false;
        }
        ary_class.push(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    添加单选按钮组的calss类 操作dom
   * 参数:
   *    @param { Promise<String> } str_css calss类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 添加成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.20
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_add_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length) {
            return false;
        }
        $("#" + str_radio_id).addClass(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    移除单选按钮组的calss类
   * 参数:
   *    @param { Promise<String> } str_css calss类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 移除成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.20
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_del_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length || "mc_radio_btn" === ary_style) {
            return false;
        }
        for (var idx_css = 0; idx_css < ary_class.length; idx_css++) {
            if (ary_class[idx_css] === str_css) {
                ary_class.splice(idx_css, 1);
                break;
            }
        }
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    移除单选按钮组的calss类 操作dom
   * 参数:
   *    @param { Promise<String> } str_css calss类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 移除成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.20
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_del_css = function (str_css) {
        if ("string" !== typeof str_css || 0 === str_css.length) {
            return false;
        }
        $("#" + str_radio_id).removeClass(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    循环单选按钮组值创建单选按钮组字串
   * 参数:
   *    @param { Promise<Array> } ary_pairs 单选按钮组值
   * 返回：
   *    @return { Promise<String> }
   *     str_val_list 单选按钮组字串
   *     "" 参数错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.20
   *      内容 : 所有代码
   ************************************************************************************************/
    function format_radio_btn_html_by_ary(ary_pairs) {
        if (!(ary_pairs instanceof Array)) {
            return "";
        }

        var i_radio_len = ary_pairs.length;
        // 单选按钮宽
        var str_radio_w = 100 / i_radio_len + "%";
        var str_val_list = "";

        for (var idx_val = 0; idx_val < i_radio_len; idx_val++) {
            var str_val = ary_pairs[idx_val];
            var str_txt = str_val;

            if ("string" === typeof str_val) {
                var i_gap_pos = str_val.indexOf("=");

                if (1 <= i_gap_pos) {
                    str_val = str_val.substr(0, i_gap_pos);
                    str_txt = str_txt.substr(i_gap_pos + 1);
                }
                str_val = str_val.trim();
                str_txt = str_txt.trim();
                if (0 === str_txt.length) {
                    str_txt = str_val;
                }
            }
            str_val_list += "<div class='mc_radio_item radio_" + idx_val + "' style='width:" + str_radio_w + "'  value='" + str_val + "' radio_select='false'>" + str_txt + "</div>";
        }
        return str_val_list;
    }

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置单选按钮组的内容
   * 参数:
   *    @param { Promise<Array> } arr_val 内容数组
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.20
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_arr = function (arr_val) {
        if (!(arr_val instanceof Array) || 0 === arr_val.length) {
            return false;
        }
        str_radio_val = arr_val;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置单选按钮组的内容 操作dom
   * 参数:
   *    @param { Promise<Array> } arr_val 内容数组
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.20
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_arr = function (arr_val) {
        if (!(arr_val instanceof Array) || 0 === arr_val.length) {
            return false;
        }
        var str_val_list = format_radio_btn_html_by_ary(arr_val);

        $("#" + str_radio_id).html(str_val_list);
        // mc_radios_event($("#" + str_radio_id)); 如需要 需注意默认选中与点击选中项 在移动时发生双选问题
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    取得单选按钮组的ID
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     单选按钮组的ID
   *     null 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.20
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_id = function () {
        if (0 === str_radio_id.length) {
            return null;
        }
        return str_radio_id;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    取得单选按钮组的ID 操作dom
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     单选按钮组的ID
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.20
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_dom_id = function () {
        return $("#" + str_radio_id).attr("id");
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置单选按钮组的title
   * 参数:
   *    @param { Promise<String> } str_title title值
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.20
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_title = function (str_title) {
        if ("string" !== typeof str_title || 0 === str_title.length) {
            return false;
        }
        str_radio_title = str_title;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置单选按钮组的title 操作dom
   * 参数:
   *    @param { Promise<String> } str_title title值
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_title = function (str_title) {
        if ("string" !== typeof str_title || 0 === str_title.length) {
            return false;
        }
        $("#" + str_radio_id).attr("title", str_title);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置单选按钮组的默认选中项
   * 参数:
   *    @param { Promise<String> } str_default 默认值选中项val
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.21
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_val = function (str_default) {
        if ("string" !== typeof str_default || 0 === str_default.length) {
            return false;
        }
        str_default_val = str_default;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置单选按钮组的默认选中项 操作dom
   * 参数:
   *    @param { Promise<String> } str_default 默认选中项val
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.21
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_val = function (str_default) {
        if ("string" !== typeof str_default || 0 === str_default.length) {
            return false;
        }
        $("#" + str_radio_id).attr("mc_radio_default", str_default);
        // var arr_radio_item = $("#" + str_radio_id).children();

        // for (var idx_radio = 0; idx_radio < arr_radio_item.length; idx_radio++) {
        //     arr_radio_item.eq(idx_radio).removeClass("mc_radio_select");
        //     var o_default_radio = arr_radio_item.eq(idx_radio);

        //     if (str_default === o_default_radio.attr("value")) {
        //         o_default_radio.addClass("mc_radio_select");
        //     }
        // }
        mc_radios_event($("#" + str_radio_id));
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    创建单选按钮组标签
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     单选按钮组标签
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.20
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_html_txt = function () {
        str_radio_id = "mc_radios" + mc_get_id();
        var str_class_list = "";
        var str_style_list = "";
        // 创建单选按钮组
        var str_val_list = format_radio_btn_html_by_ary(str_radio_val);
        // 触发回调函数
        var str_val_chg_callback_attr = "";

        for (var idx_class = 0; idx_class < ary_class.length; idx_class++) {
            str_class_list += ary_class[idx_class] + " ";
        }
        str_class_list = str_class_list.trim();
        if (0 !== ary_style.length) {
            for (var idx_style = 0; idx_style < ary_style.length; idx_style++) {
                str_style_list += ary_style[idx_style][0] + ":" + ary_style[idx_style][1] + ";";
            }
            str_style_list = str_style_list.trim();
        }

        if ("function" === typeof this.on_val_chg) {
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_key(this.on_val_chg) + "'";
        }
        return (
            "<div id='" + str_radio_id + "' class='" + str_class_list + "'  title='" + str_radio_title + "' style='" + str_style_list + "' " + str_val_chg_callback_attr + " mc_radio_default='" + str_default_val + "'>" + str_val_list + "</div>"
        );
    };
}

// 表格
function mc_ui_table() {
    var str_table_id = "";
    // 表头内容数组
    var arr_table_title = [];
    // 表格内容数组
    var arr_table_val = [];
    // 是否可写数组
    var arr_editable = [];
    var arr_style = [];

    this.on_val_chg = function () {};

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置表格高度
   * 参数:
   *    @param { Promise<String> } str_height 高度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.26
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_height = function (str_height) {
        if ("string" !== typeof str_height || 0 === str_height.length) {
            return false;
        }
        arr_style.push(["height",str_height]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置表格高度 操作dom
   * 参数:
   *    @param { Promise<String> } str_height 高度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.26
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_height = function (str_height) {
        if ("string" !== typeof str_height || 0 === str_height.length) {
            return false;
        }
        $("#" + str_table_id).css("height",str_height);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置表格表头内容
   * 参数:
   *    @param { Promise<Array> } arr_title_val 内容数组
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.23
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_title_val = function (arr_title_val) {
        if (!(arr_title_val instanceof Array) || 0 === arr_title_val.length) {
            return false;
        }
        arr_table_title = arr_title_val;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置表格表头内容 操作dom
   * 参数:
   *    @param { Promise<Array> } arr_title_val 内容数组
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.26
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_title_val = function (arr_title_val) {
        if (!(arr_title_val instanceof Array) || 0 === arr_title_val.length) {
            return false;
        }
        var arr_header = $("#" + str_table_id).children().eq(0);
        var arr_header_dom = arr_header.children();
        var i_dom_header_len = arr_header.children().length;
        var i_header_len = arr_title_val.length;
        var str_div_w = 100 / i_header_len + "%";

        if (i_header_len > i_dom_header_len) {
            var i_add_num = i_header_len - i_dom_header_len;
            var str_add_dom = "";

            // 添加超出格
            for (var idx_add = 0; idx_add < i_add_num; idx_add++) {
                str_add_dom += "<div></div>";
            }
            arr_header.append(str_add_dom);
            arr_header_dom = arr_header.children();

            for (var idx_dom_add = 0; idx_dom_add < arr_title_val.length; idx_dom_add++) {
                arr_header_dom.eq(idx_dom_add).text(arr_title_val[idx_dom_add]).css("width",str_div_w);
            }
        }
        if (i_header_len < i_dom_header_len) {
            var i_del_num = i_dom_header_len - i_header_len;

            // 删除多余格
            for (var idx_del = 0; idx_del < i_del_num; idx_del++) {
                arr_header_dom.eq(i_dom_header_len - 1 - idx_del).remove();
            }
            for (var idx_dom_del = 0; idx_dom_del < arr_title_val.length; idx_dom_del++) {
                arr_header_dom.eq(idx_dom_del).text(arr_title_val[idx_dom_del]).css("width",str_div_w);
            }
        } else {
            for (var idx_dom = 0; idx_dom < arr_title_val.length; idx_dom++) {
                arr_header_dom.eq(idx_dom).text(arr_title_val[idx_dom]);
            }
        }
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置表格内容
   * 参数:
   *    @param { Promise<Array> } arr_val 内容数组
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.23
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_val = function (arr_val) {
        if (!(arr_val instanceof Array) || 0 === arr_val.length) {
            return false;
        }
        arr_table_val = arr_val;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置表格内容 操作dom
   * 参数:
   *    @param { Promise<Array> } arr_val 内容数组
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.26
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_val = function (arr_val) {
        if (!(arr_val instanceof Array) || 0 === arr_val.length) {
            return false;
        }

        // body
        var arr_body = $("#" + str_table_id).children().eq(1);
        var arr_body_row = arr_body.children();
        var i_old_val_row = arr_body_row.length;
        var i_old_val_col = arr_body_row.eq(0).children().length;
        var i_new_val_row = arr_val.length;
        var i_new_val_col = arr_val[0].length;
        var str_li_w = 100 / i_new_val_col + "%";

        // 确定列数
        if (i_new_val_col > i_old_val_col) {
            var i_add_col_num = i_new_val_col - i_old_val_col;
            var str_add_col_li = "";

            for (var idx_add_col = 0; idx_add_col < i_add_col_num; idx_add_col++) {
                str_add_col_li += "<li></li>";
            }
            for (var idx_tr = 0; idx_tr < i_old_val_row; idx_tr++) {
                arr_body_row.eq(idx_tr).append(str_add_col_li);
            }
        }

        if (i_new_val_col < i_old_val_col) {
            var i_del_col_li = i_old_val_col - i_new_val_col;

            for (var idx_del_ul = 0; idx_del_ul < i_old_val_row; idx_del_ul++) {
                for (var idx_del_col = 0; idx_del_col < i_del_col_li; idx_del_col++) {
                    arr_body_row.eq(idx_del_ul).children().eq(i_old_val_col - 1 - idx_del_col).remove();
                }
            }
        }

        // 确定行数
        if (i_new_val_row > i_old_val_row) {
            var i_add_row_num = i_new_val_row - i_old_val_row;
            var str_add_row_li = "";
            var str_add_row = "";

            for ( var idx_add_row_li = 0; idx_add_row_li < i_new_val_col; idx_add_row_li++) {
                str_add_row_li += "<li></li>";
            }
            for (var idx_add_row = 0; idx_add_row < i_add_row_num; idx_add_row++) {
                str_add_row += "<ul class='table_row'>" + str_add_row_li + "</ul>";
            }
            arr_body.append(str_add_row);
        }

        if (i_new_val_row < i_old_val_row) {
            var i_del_row_num = i_old_val_row - i_new_val_row;

            for (var idx_del_row = 0; idx_del_row < i_del_row_num; idx_del_row++) {
                arr_body_row.eq(i_old_val_row - 1 - idx_del_row).remove();
            }
        }

        // 更改数据
        i_old_val_row = arr_body.children().length;
        i_old_val_col = arr_body.children().eq(0).children().length;
        for (var idx_ul = 0; idx_ul < i_old_val_row; idx_ul++) {
            for (var idx_li = 0; idx_li < i_old_val_col; idx_li++) {
                arr_body.children().eq(idx_ul).children().eq(idx_li).text(arr_val[idx_ul][idx_li]).css("width",str_li_w);
            }
        }

        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置表格内容是否可写
   * 参数:
   *    @param { Promise<Array> } arr_val
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.23
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_editable = function (arr_val) {
        if (!(arr_val instanceof Array) || 0 === arr_val.length) {
            return false;
        }
        arr_editable = arr_val;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置表格内容是否可写 操作dom
   * 参数:
   *    @param { Promise<Array> } arr_val
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.26
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_editable = function (arr_val) {
        if (!(arr_val instanceof Array) || 0 === arr_val.length) {
            return false;
        }
        var arr_ul = $("#" + str_table_id).children().eq(1).children();
        var i_li_len = arr_ul.eq(0).children().length;

        for (var idx_ul = 0; idx_ul < arr_ul.length; idx_ul++) {
            for (var idx_li = 0; idx_li < i_li_len; idx_li++) {
                arr_ul.eq(idx_ul).children().eq(idx_li).attr("contenteditable",arr_val[idx_ul][idx_li]);
            }
        }

        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    取得表格的ID
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     表格的ID
   *     null 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.30
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_id = function () {
        if (0 === str_table_id.length) {
            return null;
        }
        return str_table_id;
    };

    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    取得表格的ID 操作dom
    * 参数:
    *    无
    * 返回：
    *    @return { Promise<String> }
    *     表格的ID
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 陈小荟
    *      时间 : 2019.12.30
    *      内容 : 所有代码
    ************************************************************************************************/
    this.get_dom_id = function () {
        return $("#" + str_table_id).attr("id");
    };

    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    取得表格的内容 操作dom
    * 参数:
    *    无
    * 返回：
    *    @return { Promise<Array> }
    *     表格内容数组
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 陈小荟
    *      时间 : 2019.12.30
    *      内容 : 所有代码
    ************************************************************************************************/
    this.get_table_val = function () {
        var arr_ul = $("#" + str_table_id).children().eq(1).children();
        var arr_val = [];

        for (var idx_ul = 0; idx_ul < arr_ul.length; idx_ul++) {
            var o_ul = arr_ul.eq(idx_ul).children();
            var arr_table_li = [];

            for (var idx_li = 0; idx_li < o_ul.length; idx_li++) {
                arr_table_li.push(o_ul[idx_li].innerText);
            }
            arr_val.push(arr_table_li);
        }
        return arr_val;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    创建表格标签
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     表格标签
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.23
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_html_txt = function () {
        str_table_id = "mc_table" + mc_get_id();
        var str_table_style = "";
        var str_table_header_con = "";
        var str_table_body_con = "";
        var i_table_title_len = arr_table_title.length;
        var str_div_w = 100 / i_table_title_len + "%";
        var str_val_chg_callback_attr = "";

        if (0 !== arr_style.length) {
            for (var idx_body_style = 0; idx_body_style < arr_style.length; idx_body_style++) {
                str_table_style += arr_style[idx_body_style][0] + ":" + arr_style[idx_body_style][1] + ";";
            }
            str_table_style = str_table_style.trim();
        }
        for (var idx_th = 0; idx_th < i_table_title_len; idx_th++) {
            str_table_header_con += "<div style='width:" + str_div_w + "'>" + arr_table_title[idx_th] + "</div>";
        }
        for (var idx_ul = 0; idx_ul < arr_table_val.length; idx_ul++) {
            var str_table_body_li = "";

            for (var idx_li = 0; idx_li < arr_table_val[idx_ul].length; idx_li++) {
                if (0 === arr_editable.length) {
                    str_table_body_li += "<li style='width:" + str_div_w + "'>" + arr_table_val[idx_ul][idx_li] + "</li>";
                } else {
                    str_table_body_li += "<li style='width:" + str_div_w + "' contenteditable='" + arr_editable[idx_ul][idx_li] + "'>" + arr_table_val[idx_ul][idx_li] + "</li>";
                }
            }
            str_table_body_con += "<ul class='table_row'>" + str_table_body_li + "</ul>";
        }

        if ("function" === typeof this.on_val_chg) {
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_key(this.on_val_chg) + "'";
        }
        return (
            "<div id='" + str_table_id + "' class='mc_table_box' style='" + str_table_style + "' " + str_val_chg_callback_attr +
      "><div class='mc_table_header'>" + str_table_header_con +
      "</div><div class='mc_table_body'>" + str_table_body_con + "</div></div>"
        );
    };
}

// tab选项卡
function mc_ui_tabs() {
    var str_tabs_id = "";
    var arr_tabs_val = [];
    // 默认选中项下标
    var i_default_idx = 0;

    this.on_val_chg = function () {};

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置tab内容
   * 参数:
   *    @param { Promise<Array> } arr_val
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.01.03
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_val = function (arr_val) {
        if (!(arr_val instanceof Array) || 0 === arr_val.length) {
            return false;
        }
        arr_tabs_val = arr_val;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置tab默认选中项
   * 参数:
   *    @param { Promise<Number> } i_default 默认选中项下标 0起始
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.01.03
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_default = function (i_default) {
        if ("number" !== typeof i_default || 0 === i_default.length) {
            return false;
        }
        i_default_idx = i_default;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置tab默认选中项 操作dom
   * 参数:
   *    @param { Promise<Number> } i_default 默认选中项下标 0起始
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.01.03
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_default = function (i_default) {
        if ("number" !== typeof i_default || 0 === i_default.length) {
            return false;
        }
        $("#" + str_tabs_id).attr("default_idx",i_default);
        mc_tabs_event("#" + str_tabs_id);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    获取tab选线卡的ID
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<Strign> }
   *     tab选线卡ID
   *     null 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.01.03
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_id = function () {
        if (0 === str_tabs_id.length) {
            return null;
        }
        return str_tabs_id;
    };

    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    获取tab选线卡的ID 操作dom
    * 参数:
    *    无
    * 返回：
    *    @return { Promise<Strign> }
    *     tab选线卡ID
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 陈小荟
    *      时间 : 2020.01.03
    *      内容 : 所有代码
    ************************************************************************************************/
    this.get_dom_id = function () {
        return $("#" + str_tabs_id).attr("id");
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    tab选项卡标签
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     tab选项卡标签
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.01.03
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_html_txt = function () {
        str_tabs_id = "mc_tabs" + mc_get_id();
        var str_tab_header = "";

        if (0 !== arr_tabs_val.length) {
            for (var idx_li = 0; idx_li < arr_tabs_val.length; idx_li++) {
                str_tab_header += "<div tab_idx='" + idx_li + "'>" + arr_tabs_val[idx_li] + "</div>";
            }
        }

        // 触发回调函数
        var str_val_chg_callback_attr = "";

        if ("function" === typeof this.on_val_chg) {
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_key(this.on_val_chg) + "'";
        }
        return "<div id='" + str_tabs_id + "' class='mc_tab' default_idx='" + i_default_idx + "' " + str_val_chg_callback_attr + ">" + str_tab_header + "</div>";
    };
}

// 选择语言类型开关 str_div_id 需以jq方式传入 如：".select_lan_box"
function mc_ui_lan(str_div_id) {
    $(str_div_id).css({
        display: "inline-block",
        "z-index": 3
    });

    // 语言开关样式 [[width,20px],[height,20px]...]
    var arr_lan_style = [];
    // 语言项数组
    var arr_lan_val = [];
    // 默认语言类型
    var str_lan_default = "选择语言";

    // 数值改变触发 返回当前id与当前值 接受传递函数
    this.on_val_chg = function () {};

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置语言开关的样式 高
   * 参数:
   *    @param { Promise<String> } str_height 高度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.10
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_height = function (str_height) {
        if ("string" !== typeof str_height) {
            return false;
        }
        arr_lan_style.push(["height", str_height], ["line-height", str_height]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置语言开关的样式 字体颜色
   * 参数:
   *    @param { Promise<String> } str_color 颜色
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.10
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_color = function (str_color) {
        if ("string" !== typeof str_color) {
            return false;
        }
        arr_lan_style.push(["color", str_color]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置语言开关的样式 字体大小
   * 参数:
   *    @param { Promise<String> } str_size 字体大小
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.10
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_size = function (str_size) {
        if ("string" !== typeof str_size) {
            return false;
        }
        arr_lan_style.push(["font-size", str_size]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置默认语言类型
   * 参数:
   *    @param { Promise<String> } str_default 默认语言类型
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.10
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_lan_default = function (str_default) {
        if ("string" !== typeof str_default) {
            return false;
        }
        if ("默认" === str_default) {
            str_lan_default = arr_lan_val[0];
        } else {
            str_lan_default = str_default;
        }
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置语言开关项
   * 参数:
   *    @param { Promise<Array> } arr_val 语言项数组
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.10
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_lan_arr = function (arr_val) {
        if (!(arr_val instanceof Array) || 0 === arr_val.length) {
            return false;
        }
        arr_lan_val = arr_val;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    创建语言开关标签
   * 参数:
   *    无
   * 返回：
   *    无
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.10
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_lan_html = function () {
        var str_style_list = "";
        var str_html = "";

        // 创建语言选项字串
        var str_val_list = "";

        for (var idx_val = 0; idx_val < arr_lan_val.length; idx_val++) {
            str_val_list += "<li>" + arr_lan_val[idx_val] + "</li>";
        }

        // 触发回调函数
        var str_val_chg_callback_attr = "";

        if ("function" === typeof this.on_val_chg) {
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_key(this.on_val_chg) + "'";
        }

        // 样式
        if (0 !== arr_lan_style.length) {
            for (var idx_style = 0; idx_style < arr_lan_style.length; idx_style++) {
                str_style_list += arr_lan_style[idx_style][0] + ":" + arr_lan_style[idx_style][1] + ";";
            }
            str_style_list = str_style_list.trim();
            str_html = "<div class='select_lan' tabindex=0 " + str_val_chg_callback_attr + " style='" + str_style_list + "'><span>" + str_lan_default + "</span><i class='select_lan_edge'></i></div><ul class='select_lan_content'>" + str_val_list + "</ul>";
        } else {
            str_html = "<div class='select_lan' tabindex=0 " + str_val_chg_callback_attr + "><span>" + str_lan_default + "</span><i class='select_lan_edge'></i></div><ul class='select_lan_content'>" + str_val_list + "</ul>";
        }
        $(str_div_id).html(str_html);
        mc_select_lan_event(str_div_id);
    };
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    编辑框效验 整数
 * 参数:
 *    @param {String} str_val 需验证数值字串
 * 返回：
 *    @return { Promise<String> }
 *    "" 参数错误
 *    str_val 效验后字串
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_setinp_iint(str_val) {
    if ("string" !== typeof str_val || 0 === str_val.length) {
        return "";
    }
    // 去掉非数字和-
    str_val = str_val.replace(/[^\d-]/g, "");
    // 当只有0时保留
    if (1 === str_val.length && "0" === str_val) {
        return str_val;
    }
    // 开头不为0
    str_val = str_val.replace(/^0/, "");
    return str_val;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    编辑框效验 正整数
 * 参数:
 *    @param {String} str_val 需验证数值字串
 * 返回：
 *    @return { Promise<String> }
 *    "" 参数错误
 *    str_val 效验后字串
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_setinp_iuint(str_val) {
    if ("string" !== typeof str_val || 0 === str_val.length) {
        return "";
    }
    if ("0" > str_val) {
        str_val = "0";
        return str_val;
    }
    // 去掉非数字
    str_val = str_val.replace(/[^\d]/g, "");
    // 0不开头
    str_val = str_val.replace(/^0/, "");
    return str_val;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    编辑框效验 十六进制数
 * 参数:
 *    @param {String} str_val 需验证数值字串
 * 返回：
 *    @return { Promise<String> }
 *    "" 参数错误
 *    str_val 效验后字串
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_setinp_ihex(str_val) {
    if ("string" !== typeof str_val || 0 === str_val.length) {
        return "";
    }
    str_val = str_val.toUpperCase();
    // 去掉除了 A-F 0-9
    str_val = str_val.replace(/[^\dA-F]/g, "");
    // 保留四位
    str_val = str_val.slice(0, 4);
    return str_val;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    编辑框效验 浮点数和整数
 * 参数:
 *    @param {String} str_val 需效验数值字串
 * 返回：
 *    @return { Promise<String> }
 *    "" 参数错误
 *    str_val 效验后字串
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_setinp_ifloat(str_val) {
    if ("string" !== typeof str_val || 0 === str_val.length) {
        return "";
    }
    // 保证第一个为数字而不是.
    str_val = str_val.replace(/^\./g, "");
    //先把非数字的都替换掉,处理数字和.
    str_val = str_val.replace(/[^\d.-]/g, "");
    //保证只有出现一个.而没有多个.
    str_val = str_val.replace(/\.{2,}/g, ".");
    // 保留两位小数
    str_val = str_val.replace(/^(-)*(\d+)\.(\d\d).*$/, "$1$2.$3");
    return str_val;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    编辑框效验 接受所有可见字符
 * 参数:
 *    @param {String} str_val 需效验数值字串
 * 返回：
 *    @return { Promise<String> }
 *     str_val
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_setinp_i(str_val) {
    return str_val;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    编辑框数值范围比较（简化效验复杂度）
 * 参数:
 *    @param { Promise<String> } str_val 数值
 *    @param { Promise<Function> } val_type 数值类型
 *    @param { Promise<Number> } ui_scale 进制类型
 *    @param { Promise<Number> } ui_min_val 最小值
 *    @param { Promise<Number> } ui_max_val 最大值
 * 返回：
 *    @return { Promise<String> }
 *     效验后的值
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.09
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_edit_val_compare(str_val, val_type, ui_scale, ui_min_val, ui_max_val) {
    if (0 !== str_val.length) {
        if (0 === ui_scale) {
            str_val = val_type(str_val);
        } else {
            str_val = val_type(str_val, ui_scale);
        }
        if (str_val < ui_min_val) {
            str_val = ui_min_val;
        }
        if (str_val > ui_max_val) {
            str_val = ui_max_val;
        }
    }
    if (16 === ui_scale) {
        return str_val.toString(16);
    }
    return str_val.toString();
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    编辑框数值效验
 * 参数:
 *    @param { Promise<String> } str_val 数值
 *    @param { Promise<String> } str_val_type 数值类型 可为空（接受所有可见字符）
 *    @param { Promise<String> } str_val_min 最小值 可为空
 *    @param { Promise<String> } str_val_max 最大值 可为空
 *    @param { Promise<String> } str_default_digit 默认值位数
 * 返回：
 *    @return { Promise<String> }
 *     效验后的值
 *     null 参数错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.04
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_edit_val_check(str_val, str_val_type, str_val_min, str_val_max, str_default_digit) {
    if ("string" !== typeof str_val || 0 === str_val.length || "string" !== typeof str_val_type) {
        return str_val;
    }
    // 无最小值
    if ("string" !== typeof str_val_min || 0 === str_val_min.length) {
        str_val_min = "";
    }
    // 无最大值
    if ("string" !== typeof str_val_max || 0 === str_val_max.length) {
        str_val_max = "";
    }
    str_val_type = str_val_type.toUpperCase();
    str_val = str_val.toUpperCase();

    switch (str_val_type) {
    case "INT":
        if ("0" !== str_val) {
        // 去掉非数字 除了数字和-
            str_val = str_val.replace(/[^\d-]/g, "");
            // 0 不开头
            str_val = str_val.replace(/^0/, "");
        }
        var ui_int_min_val = parseInt(str_val_min, 10);
        var ui_int_max_val = parseInt(str_val_max, 10);
        var ui_int_val = str_val;

        ui_int_val = mc_edit_val_compare(ui_int_val, parseInt, 10, ui_int_min_val, ui_int_max_val);
        return ui_int_val;
    case "UINT":
        if ("0" !== str_val && "0" < str_val) {
            // 去掉非数字
            str_val = str_val.replace(/[^\d]/g, "");
            // 0 不开头
            str_val = str_val.replace(/^0/, "");
        } else {
            str_val = "0";
        }
        var ui_uint_min_val = parseInt(str_val_min, 10);
        var ui_uint_max_val = parseInt(str_val_max, 10);
        var ui_uint_val = str_val;

        ui_uint_val = mc_edit_val_compare(ui_uint_val, parseInt, 10, ui_uint_min_val, ui_uint_max_val);
        return ui_uint_val;
    case "HEX":
        str_val = str_val.replace(/[^\dA-F]/g, "");
        var ui_hex_min_val = parseInt(str_val_min, 16);
        var ui_hex_max_val = parseInt(str_val_max, 16);
        var ui_hex_val = str_val;

        ui_hex_val = mc_edit_val_compare(ui_hex_val, parseInt, 16, ui_hex_min_val, ui_hex_max_val);
        if ("string" === typeof str_default_digit) {
            str_default_digit = parseInt(str_default_digit, 10);
        }
        ui_hex_val = ui_hex_val.toUpperCase();
        // 不足位数补零
        return (Array(str_default_digit).join(0) + ui_hex_val).slice(-str_default_digit);
    case "FLOAT":
        // 保证第一个为数字而不是.
        str_val = str_val.replace(/^\./g, "");
        //先把非数字的都替换掉,处理数字和.
        str_val = str_val.replace(/[^\d.-]/g, "");
        //保证只有出现一个.而没有多个.
        str_val = str_val.replace(/\.{2,}/g, ".");
        // 保留两位小数
        str_val = str_val.replace(/^(-)*(\d+)\.(\d\d).*$/, "$1$2.$3");
        var ui_float_min_val = parseFloat(str_val_min);
        var ui_float_max_val = parseFloat(str_val_max);
        var ui_float_val = str_val;

        ui_float_val = mc_edit_val_compare(ui_float_val, parseFloat, 0, ui_float_min_val, ui_float_max_val);
        return ui_float_val;
    default:
        break;
    }
    return str_val;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    取出函数名
 * 参数:
 *    @param {Function} func 函数
 * 返回：
 *    @return { Promise<String> }
 *     函数名称
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_func_key(func) {
    if ("function" !== typeof func) {
        return "";
    }

    /* 如果有必要，考虑使用 MDK 算func的哈希作为key */
    var func_name = func.toString().split("(")[0].split(" ")[1];

    func_name = func_name.trim();
    func_name = func_name.toLowerCase();

    if ("string" === typeof func_name && 0 < func_name.length && "function" !== typeof g_obj_func_name_map[func_name]) {
        g_obj_func_name_map[func_name] = func;
    }

    return func_name;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    计算移动网格数
 * 参数:
 *    @param {Number} ui_curr_left 移动量
 *    @param {Number} ui_max_left 移动范围
 *    @param {Number} ui_grid_pix 每格像素
 * 返回：
 *    @return { Promise<String> }
 *     函数名称
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.11
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_move_grid_idx(ui_curr_left, ui_max_left, ui_grid_pix) {
    if ("number" !== typeof ui_curr_left || 0 === ui_curr_left.length || "number" !== typeof ui_max_left || 0 === ui_max_left.length || "number" !== typeof ui_grid_pix || 0 === ui_grid_pix.length) {
        return null;
    }
    if (0 > ui_curr_left) {
        ui_curr_left = 0;
    }
    if (ui_max_left < ui_curr_left) {
        ui_curr_left = ui_max_left;
    }
    var ui_grid_idx = Math.floor(ui_curr_left / ui_grid_pix);

    return ui_grid_idx;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    div contenteditable=true 控制光标位置在最后
 * 参数:
 *    @param {Object} obj 当前对象
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.13
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_set_focus(obj) {
    var range = null;

    if ($.support.msie) {
        range = document.selection.createRange();
        $(obj).last = range;
        range.moveToElementText($(obj)[0]);
        range.select();
        //取消选中
        document.selection.empty();
    } else {
        range = document.createRange();

        range.selectNodeContents($(obj)[0]);
        range.collapse(false);
        var sel = window.getSelection();

        sel.removeAllRanges();
        sel.addRange(range);
    }

    $(obj).focus();
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    判断是否为PC端
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<Boolean> }
 *    true PC端
 *    false 移动端
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.19
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_ispc() {
    var str_useragent_info = navigator.userAgent;
    var arr_agents = ["Android", "iPhone", "SymbianOS", "Windows Phone", "iPad", "iPod"];
    var flag = true;

    for (var v = 0; v < arr_agents.length; v++) {
        if (0 < str_useragent_info.indexOf(arr_agents[v])) {
            flag = false;
            break;
        }
    }
    return flag;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    操作dom的jq相关操作
 * 参数:
 *    无
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_item_js_fun() {
    // PC端滚动条生效
    var b_ispc = mc_ispc();

    if (b_ispc) {
        setTimeout(function () {
            $("#mc_wrap_div").getNiceScroll().resize();
        }, 500);
        // 去除横向滚动条
        $("#ascrail2000-hr").remove();

        // 初始化表格滚动条
        $(".mc_table_body").niceScroll();
    }

    mc_edit_event(".mc_edit");
    mc_step_edit_event();
    mc_checkbox_event(".mc_checkbox_box");
    mc_slider_event(".mc_slider_thumb");
    mc_select_event(".mc_opt_select");
    mc_radios_event(".mc_radio_btn");
    mc_table_event(".mc_table_body");
    mc_tabs_event(".mc_tab");
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    编辑框事件
 * 参数:
 *    @param {Object} obj 当前对象
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.09
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_edit_event(obj) {
    // 编辑框失去焦点
    $(obj).off("blur");
    $(obj).on("blur", function () {
    // 隐藏光标
        $(this).addClass("mc_step_focus");
        var str_edit_val = $(this).text();
        // 数据类型
        var str_val_type = $(this).attr("mc_edit_type");
        // 最大最小值
        var str_val_min = $(this).attr("cui_min_val");
        var str_val_max = $(this).attr("cui_max_val");
        // 默认值位数
        var str_default_digit = $(this).attr("default_digit");

        // 效验
        str_edit_val = mc_edit_val_check(str_edit_val, str_val_type, str_val_min, str_val_max, str_default_digit);

        $(this).text(str_edit_val);

        // 返回新值
        var str_id = $(this).attr("id");
        var str_val = $(this).text();

        return_new_value($(this),str_id,str_val);
    });

    // 显示光标
    $(obj).off("click");
    $(obj).on("click", function () {
        $(this).removeClass("mc_step_focus");
    });

    // 编辑框输入效验
    $(obj).off("keyup");
    $(obj).on("keyup", function (event) {
        var e = event || window.event;

        if (13 === e.keyCode) {
            $(this).blur();
        }
        var str_val = $(this).text();
        var str_type = $(this).attr("mc_edit_type");
        var fn_name = "mc_setinp_i" + str_type;
        var str_result_val = window[fn_name](str_val);

        $(this).text(str_result_val);

        // 控制光标位置在最后
        mc_set_focus($(this));
    });
}

/********步进编辑框设定***********************************************************************/
function mc_step_edit_event() {
    // 步进编辑框 加
    $(".mc_step_edit_wrap").off("click", ".mc_step_add");
    $(".mc_step_edit_wrap").on("click", ".mc_step_add", function () {
        var o_step_inp = $(this).prev();
        // inp值获取
        var str_step_val = o_step_inp.text();
        // 数据类型
        var str_val_type = o_step_inp.attr("mc_step_type");
        // 获取最大值
        var str_val_max = $(this).attr("cui_max_val");
        // 获取最小值
        var str_val_min = o_step_inp.prev().attr("cui_min_val");
        // 默认值位数
        var str_default_digit = o_step_inp.attr("default_digit");
        // 获取步进值
        var cui_step = o_step_inp.attr("cui_step");

        str_step_val = (parseFloat(str_step_val) + parseFloat(cui_step)).toString();
        // 效验
        str_step_val = mc_edit_val_check(str_step_val, str_val_type, str_val_min, str_val_max, str_default_digit);
        o_step_inp.text(str_step_val);
        // 标识编辑状态
        b_edit_step_select = true;
        // 将当前id与新的值返回
        var str_id = o_step_inp.attr("id");
        var str_val = o_step_inp.text();

        return_new_value(o_step_inp,str_id,str_val);
    });

    // 步进编辑框 减
    $(".mc_step_edit_wrap").off("click", ".mc_step_sub");
    $(".mc_step_edit_wrap").on("click", ".mc_step_sub", function () {
        var o_step_inp = $(this).next();
        // inp值获取
        var str_step_val = o_step_inp.text();
        // 数据类型
        var str_val_type = o_step_inp.attr("mc_step_type");
        // 获取最大值
        var str_val_max = o_step_inp.next().attr("cui_max_val");
        // 获取最小值
        var str_val_min = $(this).attr("cui_min_val");
        // 默认值位数
        var str_default_digit = o_step_inp.attr("default_digit");
        // 获取步进值
        var cui_step = o_step_inp.attr("cui_step");

        str_step_val = (parseFloat(str_step_val) - parseFloat(cui_step)).toString();
        // 效验
        str_step_val = mc_edit_val_check(str_step_val, str_val_type, str_val_min, str_val_max, str_default_digit);
        b_edit_step_select = false;
        o_step_inp.text(str_step_val);
        // 返回新值
        var str_id = o_step_inp.attr("id");
        var str_val = o_step_inp.text();

        return_new_value(o_step_inp,str_id,str_val);
    });

    // 步进编辑框失去焦点操作 返回ID和新值
    $(".mc_step_edit_wrap").off("blur", ".mc_step_inp");
    $(".mc_step_edit_wrap").on("blur", ".mc_step_inp", function () {
    // 隐藏光标
        $(this).addClass("mc_step_focus");
        // inp值获取
        var str_step_val = $(this).text();
        // 数据类型
        var str_val_type = $(this).attr("mc_step_type");
        // 获取最大值
        var str_val_max = $(this).next().attr("cui_max_val");
        // 获取最小值
        var str_val_min = $(this).prev().attr("cui_min_val");
        // 默认值位数
        var str_default_digit = $(this).attr("default_digit");

        // 效验
        str_step_val = mc_edit_val_check(str_step_val, str_val_type, str_val_min, str_val_max, str_default_digit);

        $(this).text(str_step_val);
        b_edit_step_select = false;

        // 返回新值
        var str_id = $(this).attr("id");
        var str_val = $(this).text();

        return_new_value($(this),str_id,str_val);
    });

    // 显示光标
    $(".mc_step_edit_wrap").off("click", ".mc_step_inp");
    $(".mc_step_edit_wrap").on("click", ".mc_step_inp", function () {
        $(this).removeClass("mc_step_focus");
        b_edit_step_select = true;
    });

    // 步进编辑框输入效验
    $(".mc_step_edit_wrap").off("keyup", ".mc_step_inp");
    $(".mc_step_edit_wrap").on("keyup", ".mc_step_inp", function (e) {
    // 回车
        if (13 === e.keyCode) {
            $(this).blur();
            b_edit_step_select = false;
        }
        var str_val = $(this).text();
        var str_type = $(this).attr("mc_step_type");
        var fn_name = "mc_setinp_i" + str_type;

        var str_result_val = window[fn_name](str_val);
        var str_min_val = $(this).prev().attr("cui_min_val");

        if ("" === str_result_val) {
            str_result_val = str_min_val;
        }
        $(this).text(str_result_val);
        b_edit_step_select = true;
        if ($(this).hasClass("mc_step_focus")) {
            b_edit_step_select = false;
        }
        // 控制光标位置在最后
        mc_set_focus($(this));
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    复选框点击添加选中class类
 * 参数:
 *    @param {Object} obj 当前对象
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.09
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_checkbox_event(obj) {
    function checkbox_set_class(o_on, o_off) {
        o_off.removeClass("mc_checkbox_select_btn");
        o_on.removeClass("mc_checkbox_select_btn");
        o_off.removeClass("checkbox_flex_box_auto_size");
        o_on.removeClass("checkbox_flex_box_auto_size");
    }

    $(obj).off("click");
    $(obj).on("click", function () {
        var o_checkbox_on = $(this).children().eq(0);
        var o_checkbox_off = $(this).children().eq(1);
        var str_select_status = $(this).attr("checkbox_select");
        // 判断是否选中 ture false
        var str_val = false;

        checkbox_set_class(o_checkbox_on, o_checkbox_off);

        if ("true" === str_select_status) {
            o_checkbox_on.addClass("checkbox_flex_box_auto_size");
            o_checkbox_off.addClass("mc_checkbox_select_btn");
            $(this).attr("checkbox_select", "false");
        } else {
            o_checkbox_on.addClass("mc_checkbox_select_btn");
            o_checkbox_off.addClass("checkbox_flex_box_auto_size");
            $(this).attr("checkbox_select", "true");
            str_val = true;
        }

        // 将当前id与新的值返回
        var str_id = $(this).attr("id");

        return_new_value($(this),str_id,str_val);
    });

    // 默认选中状态
    if (0 !== $(obj).length) {
        for (var idx_checkbox = 0, len = $(obj).length; idx_checkbox < len; idx_checkbox++) {
            var now_checkbox = $(obj).eq(idx_checkbox);
            var o_checkbox_on = now_checkbox.children().eq(0);
            var o_checkbox_off = now_checkbox.children().eq(1);

            checkbox_set_class(o_checkbox_on, o_checkbox_off);

            if ("true" === now_checkbox.attr("checkbox_select")) {
                o_checkbox_on.addClass("mc_checkbox_select_btn");
                o_checkbox_off.addClass("checkbox_flex_box_auto_size");
            }

            if ("false" === now_checkbox.attr("checkbox_select")) {
                o_checkbox_on.addClass("checkbox_flex_box_auto_size");
                o_checkbox_off.addClass("mc_checkbox_select_btn");
            }
        }
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    滑动条操作
 * 参数:
 *    @param {Object} obj 当前对象
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.09
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_slider_event(obj) {
    // 滑块最大值最小值 步进值
    var val_min_value = 0;
    var val_max_value = 100;
    var val_step_value = 1;

    // 滑动范围
    var df_max_left = 100;
    // 格子数
    var ui_grid_cnt = 100;
    // 每格像素
    var df_grid_pix = 1;

    // 滑块文本 默认值
    var slider_thumb_text = 1;

    // 初始化滑块位置
    function slider_thumb_init() {
        if (0 !== $(obj).length) {
            for (var idx_thumb = 0, len = $(obj).length; idx_thumb < len; idx_thumb++) {
                var now_thumb = $(obj).eq(idx_thumb);

                val_min_value = parseFloat(now_thumb.prev().prev().html());
                val_max_value = parseFloat(now_thumb.prev().html());
                val_step_value = parseFloat(now_thumb.attr("cui_step"));

                df_max_left = now_thumb.parent().width() - 2 - now_thumb.width();
                ui_grid_cnt = Math.round((val_max_value - val_min_value) / val_step_value);
                df_grid_pix = df_max_left / ui_grid_cnt;

                // 滑块默认位置
                slider_thumb_text = parseFloat(now_thumb.attr("default_val"));

                if (slider_thumb_text > val_max_value) {
                    slider_thumb_text = val_max_value;
                }
                if (slider_thumb_text < val_min_value) {
                    slider_thumb_text = val_min_value;
                }
                var ui_grid_idx = Math.round((slider_thumb_text - val_min_value) / val_step_value);
                var ui_curr_left = ui_grid_idx * df_grid_pix;

                now_thumb.attr("now_left", ui_curr_left).css("left", ui_curr_left + "px").text(slider_thumb_text);
            }
        }
    }

    // 窗口大小改变重新初始化位置
    $(window).off("resize");
    $(window).on("resize", function () {
        slider_thumb_init();

        // 表格滚动条备选
        // if (0 < $(".mc_table_box").length) {
        //     var o_table = $(".mc_table_box");
        //     var i_table_height = o_table.parent().parent().height();
        //     var i_table_header = o_table.children().eq(0).height();
        //     var str_table_body_h = (i_table_height - i_table_header - 10) + "px";

        //     $(".mc_table_body").css("height",str_table_body_h);
        // }
    });

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    滑块事件操作 按下
   * 参数:
   *    @param {Object} obj_this 当前对象
   * 返回：
   *    无
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.19
   *      内容 : 所有代码
   ************************************************************************************************/
    function slider_handerin(obj_this) {
        val_min_value = parseFloat(obj_this.prev().prev().html());
        val_max_value = parseFloat(obj_this.prev().html());
        val_step_value = parseFloat(obj_this.attr("cui_step"));
        df_max_left = obj_this.parent().width() - 2 - obj_this.width();
        ui_grid_cnt = Math.round((val_max_value - val_min_value) / val_step_value);
        df_grid_pix = df_max_left / ui_grid_cnt;
        // 禁止编辑模式及选中
        obj_this.attr("contenteditable", "false");
        obj_this.removeClass("mc_slider_thumb_uselect").addClass("mc_slider_thumb_nuselect");
    }

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    滑块事件操作 移动
   * 参数:
   *    @param {Object} obj_this 当前对象
   *    @param {Number} i_ms_left  鼠标左偏移量
   *    @param {Number} i_grid_pix 滑动条每格像素
   *    @param {Number} i_ms_top  鼠标上偏移量
   *    @param {Number} i_dowm_top  按下时距离元素顶部距离
   *    @param {Number} i_dowm_bottom  按下时距离元素底部距离
   *    @param {Number} i_base_left  按下时滑块位置
   *    @param {Number} i_max_left  滑动最大距离
   *    @param {Number} i_grid_cnt  格子数
   *    @param {Number} i_step_value  步进值
   *    @param {Number} i_min_value  滑动条最小值
   * 返回：i
   *    无
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.19
   *      内容 : 所有代码
   ************************************************************************************************/
    function slider_handermove(obj_this,i_ms_left,i_grid_pix,i_ms_top,i_dowm_top,i_dowm_bottom,i_base_left,i_max_left,i_grid_cnt,i_step_value,i_min_value) {
        if (Math.abs(i_ms_left) < i_grid_pix) {
            return;
        }

        if (Math.abs(i_ms_top) > i_dowm_top || Math.abs(i_ms_top) > i_dowm_bottom) {
            // 将当前值返回
            // var str_id = obj_this.parent().attr("id");
            // var str_val = obj_this.text();
            // return_new_value(obj_this,str_id,str_val);
            $(document).off("mousemove");
            $(document).off("touchmove");
        }
        // 移动量
        var ui_curr_l = i_base_left + i_ms_left;
        var val = 0;
        // 移动网格数
        var ui_grid_i = mc_move_grid_idx(ui_curr_l, i_max_left, i_grid_pix);

        if (i_grid_cnt <= ui_grid_i + 1) {
            ui_curr_l = i_max_left;
            val = val_max_value;
        } else {
            ui_curr_l = ui_grid_i * i_grid_pix;
            val = ui_grid_i * i_step_value + i_min_value;
        }

        obj_this.attr("now_left", ui_curr_l);
        obj_this.css({left: ui_curr_l + "px"}).text(parseFloat(val.toFixed(5)));

        // 修改默认位置
        obj_this.attr("default_val", parseFloat(val.toFixed(5)));
        slider_handerout(obj_this, i_ms_left);
    }

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    滑块事件操作 抬起
   * 参数:
   *    @param {Object} obj_this 当前对象
   *    @param {Number} i_offset 偏移量
   * 返回：
   *    无
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.19
   *      内容 : 所有代码
   ************************************************************************************************/
    function slider_handerout(obj_this, i_offset) {
        if (0 < Math.abs(i_offset)) {
            // 将当前id与新的值返回
            var str_id = obj_this.parent().attr("id");
            var str_val = obj_this.text();

            return_new_value(obj_this,str_id,str_val);
        } else {
            // 开启编辑模式及选中
            obj_this.attr("contenteditable", "true");
            obj_this.addClass("mc_slider_thumb_uselect").removeClass("mc_slider_thumb_nuselect");

            // 光标移到最后
            mc_set_focus(obj_this);
        }
    }

    // 滑动条滑动封装
    $.fn.extend({
        mc_drag: function () {
            $(this).off("mousedown");
            $(this).on("mousedown", function (event) {
                var e = event || window.event;
                var $this = $(this);

                slider_handerin($this);
                // 鼠标偏移
                var i_start_left = e.clientX;
                var i_start_top = e.clientY;

                var i_offset_top = $(this).offset().top;
                var i_this_height = $(this).height() + 2;

                // 点击时距离元素顶部及底部距离
                var i_dowm_top = i_start_top - i_offset_top;
                var i_dowm_bottom = i_offset_top + i_this_height - i_start_top;

                // 当前位置
                var i_base_left = parseFloat($this.attr("now_left"));

                $(document).on("mousemove", function (event_move) {
                    var e_move = event_move || window.event_move;

                    val_step_value = parseFloat($this.attr("cui_step"));
                    // 鼠标偏移
                    var df_ms_left = e_move.clientX - i_start_left;
                    var df_ms_top = e_move.clientY - i_start_top;

                    slider_handermove($this,df_ms_left,df_grid_pix,df_ms_top,i_dowm_top,i_dowm_bottom,i_base_left,df_max_left,ui_grid_cnt,val_step_value,val_min_value);
                });
                $(this).off("mouseup");
                $(this).on("mouseup", function (event_up) {
                    $(document).off("mousemove");
                    var e_up = event_up || window.event_up;
                    var i_offset = e_up.clientX - i_start_left;

                    slider_handerout($this, i_offset);
                });
            });

            // 移动端
            $(this).on("touchstart", function (event) {
                var e = event || window.event;
                var $this = $(this);

                slider_handerin($this);

                // 鼠标偏移
                var i_start_left = e.originalEvent.touches[0].pageX;
                var i_start_top = e.originalEvent.touches[0].pageY;

                var i_offset_top = $(this).offset().top;
                var i_this_height = $(this).height() + 2;

                // 点击时距离元素顶部及底部距离
                var i_dowm_top = i_start_top - i_offset_top;
                var i_dowm_bottom = i_offset_top + i_this_height - i_start_top;

                // 当前位置
                var i_base_left = parseFloat($this.attr("now_left"));

                var i_move_pagex = 0;

                $(document).on("touchmove", function (event_move) {
                    var e_move = event_move || window.event_move;

                    val_step_value = parseFloat($this.attr("cui_step"));
                    // 鼠标偏移
                    var df_ms_left = e_move.originalEvent.touches[0].pageX - i_start_left;
                    var df_ms_top = e_move.originalEvent.touches[0].pageY - i_start_top;

                    slider_handermove( $this, df_ms_left, df_grid_pix, df_ms_top, i_dowm_top, i_dowm_bottom, i_base_left, df_max_left, ui_grid_cnt, val_step_value, val_min_value);
                    i_move_pagex = e_move.originalEvent.touches[0].pageX;
                });
                $(this).off("touchend");
                $(this).on("touchend", function () {
                    $(document).off("touchmove");
                    var i_offset = i_move_pagex - i_start_left;

                    slider_handerout($this, i_offset);
                });
            });
        }
    });

    // 滑块失去焦点
    $(obj).off("blur");
    $(obj).on("blur", function () {
        $(this).removeClass("mc_slider_thumb_keycode");
        var inp_val = parseFloat($(this).text());

        if (isNaN(inp_val)) {
            var i_nochg_text = (parseFloat($(this).attr("now_left")) / df_grid_pix) * val_step_value + val_min_value;

            $(this).text(i_nochg_text);
            return;
        }
        if (inp_val > val_max_value) {
            inp_val = val_max_value;
        }
        if (inp_val < val_min_value) {
            inp_val = val_min_value;
        }
        var ui_grid_i = Math.round((inp_val - val_min_value) / val_step_value);
        var ui_curr_l = ui_grid_i * df_grid_pix;

        // 保存当前inp位置
        $(this).attr("now_left", ui_curr_l);
        $(this).animate({left: ui_curr_l + "px"},500,function () {
            // 返回新值
            var str_id = $(this).parent().attr("id");
            var str_val = $(this).text();
            var str_fun_name = $(this).attr(g_str_attr_lab_val_chg);

            if ("string" === typeof str_fun_name && 0 < str_fun_name.length) {
                var fun_callback = g_obj_func_name_map[str_fun_name];

                if ("function" === typeof fun_callback) {
                    if ("" === str_id) {
                        fun_callback(str_val);
                    } else {
                        fun_callback(str_id,str_val);
                    }
                }
            }
        }).text(parseFloat(ui_grid_i * val_step_value + val_min_value));

        // 修改默认位置
        $(this).attr("default_val", parseFloat(ui_grid_i * val_step_value + val_min_value));
    });

    // 滑块键盘操作
    $(obj).off("keydown");
    $(obj).on("keydown", function (e) {
    // 光标移到最后
        mc_set_focus($(this));
        // 去除光标
        $(this).addClass("mc_slider_thumb_keycode");
        var inp_val = parseFloat($(this).text());
        var i_base_left = parseFloat($(this).attr("now_left"));
        // 移动范围
        var i_left_val = 0;
        // 显示数值
        var i_text = 0;

        if (inp_val > val_max_value) {
            inp_val = val_max_value;
        }
        if (inp_val < val_min_value) {
            inp_val = val_min_value;
        }
        if (13 === e.keyCode) {
            $(this).blur();
        }
        // 上右
        if (38 === e.keyCode || 39 === e.keyCode) {
            i_left_val = i_base_left + df_grid_pix * val_step_value;
            if (df_max_left < i_left_val) {
                i_left_val = df_max_left;
            }
            i_text = inp_val + val_step_value;
            if (i_text > val_max_value) {
                i_text = val_max_value;
            }
            $(this).css("left", i_left_val + "px").text(i_text);
            $(this).attr("now_left", i_left_val);
        }
        // 下左
        if (37 === e.keyCode || 40 === e.keyCode) {
            i_left_val = i_base_left - df_grid_pix * val_step_value;
            if (0 > i_left_val) {
                i_left_val = 0;
            }
            i_text = inp_val - val_step_value;
            if (i_text < val_min_value) {
                i_text = val_min_value;
            }
            $(this).css("left", i_left_val + "px").text(i_text);
            $(this).attr("now_left", i_left_val);
        }
    });

    // 滑块拖拽
    $(obj).mc_drag();
    // 初始化滑块位置
    slider_thumb_init();
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    下拉框操作
 * 参数:
 *    @param {Object} obj 当前对象
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.02.19
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_select_event(obj) {
    $(".select_list").niceScroll({ autohidemode: "leave" });
    // 分类列表内容显示第一个
    $(".sc_search_cont0").css("display","flex");

    // 列表value
    var arr_option_key = [];
    // 列表内容
    var arr_option_val = [];
    // 列表标签
    var str_option_list = "";
    // 起始位置下标
    var i_start = -1;
    // 记录页数
    var i_page = 0;
    // 数据总页数
    var i_all_page = 1;
    // 键盘上下移动时 保存当前选中项key
    var str_now_select = "";

    // 搜索框点击动作 -> 搜索框动作
    $(obj).off("click");
    $(obj).on("click", ".select_text", function () {
        var str_select_default_val = $(this).parent().attr("mc_select_default");
        var o_select_txt = $(this).children().eq(0);
        var o_btn_box = $(this).children().eq(1);

        arr_option_key = [];
        arr_option_val = [];
        str_option_list = "";
        var arr_select_classify_c = $(this).next().next().children();

        for (var idx_cont = 2; idx_cont < arr_select_classify_c.length - 1; idx_cont++) {
            var o_cont_list = arr_select_classify_c.eq(idx_cont).children(".sc_cont_right").children();

            for (var idx_cont_li = 0; idx_cont_li < o_cont_list.length; idx_cont_li++) {
                var o_ul = o_cont_list.eq(idx_cont_li);
                var o_li = o_ul.children();

                for (var idx_val = 0; idx_val < o_li.length; idx_val++) {
                    var o_li_val = o_li.eq(idx_val);
                    var str_item_text = o_li_val.text();
                    var str_item_key = o_li_val.attr("value");

                    // arr_select_save_val.push(str_val);
                    arr_option_key.push(str_item_key);
                    arr_option_val.push(str_item_text);
                    str_option_list += "<li value='" + str_item_key + "'>" + str_item_text + "</li>";
                }
            }
        }

        // 关闭其他按钮
        $(".select_btn_box").addClass("close_btn_tab");
        o_btn_box.removeClass("close_btn_tab");
        $(".close_btn_tab").removeClass("select_btn_rotate");

        // 将输入框清空
        o_select_txt.text("");
        // 分类列表是否隐藏
        if ("false" === $(this).parent().children(".select_classify").attr("b_is_none")) {
            var o_select_classify = $(this).next().next();

            // 初始化显示数据
            i_page = 0;
            mc_limit_data(o_select_classify.children(".sc_search_cont0").children(".sc_cont_right"),i_page);
            // 第一页时处理分页按钮
            if ("true" === o_select_classify.children().eq(2).attr("block_sc_flip")) {
                $(".sc_flip").css("display","block");
            } else {
                $(".sc_flip").css("display","none");
            }

            // 默认分类列表选中第一个
            o_select_classify.children().eq(1).children().eq(0).addClass("sc_title_active").siblings().removeClass("sc_title_active");
            var arr_search_title = o_select_classify.children().eq(1).children();

            for ( var idx_sc_title = 0; idx_sc_title < arr_search_title.length; idx_sc_title++ ) {
                if (0 === idx_sc_title) {
                // control_flip 分页显示标识
                    $(".sc_search_cont" + idx_sc_title).css("display","flex").addClass("control_flip");
                } else {
                    $(".sc_search_cont" + idx_sc_title).css("display","none").removeClass("control_flip");
                }
            }

            // 将列表收起
            $(this).next().css("display", "none");

            // 关闭其他列表
            $(".select_classify").addClass("close_list_tab");
            o_select_classify.removeClass("close_list_tab");
            $(".close_list_tab").css("display","none");
            $(".select_list").addClass("close_list_tab");
            o_btn_box.prev().removeClass("close_list_tab");
            $(".close_list_tab").css("display","none");

            // 分类搜索框显示隐藏
            o_select_classify.toggle();
        } else {
            // 关闭其他列表
            if ($(".select_classify")) {
                $(".select_classify").addClass("close_list_tab");
            }
            $(".select_list").addClass("close_list_tab");
            $(this).next().removeClass("close_list_tab");
            $(".close_list_tab").css("display","none");

            // 下拉列表显示隐藏
            $(this).next().toggle();
        }

        // 控制开关
        if (o_btn_box.hasClass("select_btn_rotate")) {
            o_btn_box.removeClass("select_btn_rotate");
            if ("" === o_select_txt.text()) {
                o_select_txt.text(str_select_default_val).attr("contenteditable","false");
            }
        } else {
            // 判断是否禁止输入
            // if ("true" === $(this).children(".select_txt").attr("contenteditable")) {
            if ("true" === $(this).children(".select_txt").attr("is_edit")) {
                o_select_txt.attr("contenteditable","true");
            }

            o_btn_box.addClass("select_btn_rotate");
            // 选中起始重置
            i_start = -1;
            $(this).next().attr("star_idx", "true");
        }

        o_select_txt.focus();
        mc_set_focus(o_select_txt);
        b_edit_step_select = true;
    });

    // 列表点击动作 -> 列表选中
    $(obj).off("click", ".select_list li");
    $(obj).on("click", ".select_list li", function () {
        var o_select_list = $(this).parent();
        var arr_select_list = o_select_list.children();
        var str_text = $(this).text();

        for (var idx_item = 0; idx_item < arr_select_list.length; idx_item++) {
            arr_select_list.eq(idx_item).attr("before_select", false);
        }
        $(this).attr("before_select", true);
        o_select_list.prev().children().eq(0).text(str_text).next().removeClass("select_btn_rotate");
        o_select_list.toggle();

        var o_select = o_select_list.parent();

        b_edit_step_select = false;
        // 修改默认值
        if ("" !== str_text) {
            o_select.attr("mc_select_default",str_text);
        }
        o_select_list.prev().children().eq(0).attr("b_show_default",false);
        // 返回新值
        var str_id = o_select.attr("id");
        var str_val = $(this).attr("value");

        return_new_value(o_select,str_id,str_val);
    });

    // **此处添加选中样式 后续可优化（不需要）
    // 列表鼠标移动动作 -> 选中样式唯一
    $(obj).off("mousemove", ".select_list li");
    $(obj).on("mousemove", ".select_list li", function () {
        var arr_select = $(this).parent().children();

        for (var idx_item = 0; idx_item < arr_select.length; idx_item++) {
            arr_select.eq(idx_item).removeClass("select_focus");
        }
        $(this).addClass("select_focus");
    });

    // 搜索框键盘动作 -> 模糊搜索 键盘上下键移动列表选中项
    $(obj).off("keyup", ".select_txt");
    $(obj).on("keyup", ".select_txt", function (event) {
        // if ("true" === $(this).attr("contenteditable")) {
        if ("true" === $(this).attr("is_edit")) {
            $(this).attr("contenteditable", "true");
        }
        // 将分类搜索框收起
        $(this).parent().next().next().css("display", "none");
        var e = event || window.event;
        // 匹配值
        var arr_search_key = [];
        var arr_search_val = [];
        var str_val = $(this).text().toUpperCase();
        var o_select_list = $(this).parent().next();
        var arr_select_list = o_select_list.children();

        // 将其他下拉列表收起
        $(".select_list").addClass("close_list_tab");
        o_select_list.removeClass("close_list_tab");
        $(".close_list_tab").css("display","none");

        // 模糊搜索
        if (38 !== e.keyCode && 40 !== e.keyCode && 13 !== e.keyCode) {
        // 重新确定起始位置
            o_select_list.attr("star_idx", "true");
            i_start = -1;

            o_select_list.css("display", "block");
            $(this).next().addClass("select_btn_rotate");
            for (var idx_arr_option = 0; idx_arr_option < arr_option_val.length; idx_arr_option++) {
                var str_option_key = arr_option_key[idx_arr_option];
                var str_option_val = arr_option_val[idx_arr_option];

                if (-1 < str_option_val.toUpperCase().indexOf(str_val)) {
                    arr_search_key.push(str_option_key);
                    arr_search_val.push(str_option_val);
                }
            }
            // 匹配标签
            var str_search_list = "";

            for (var idx_html = 0; idx_html < arr_search_val.length; idx_html++) {
                str_search_list += "<li value='" + arr_search_key[idx_html] + "'>" + arr_search_val[idx_html] + "</li>";
            }
            if ("" === str_search_list) {
                o_select_list.html("").append("<li>无匹配项</li>");
                $(this).attr("b_show_default",true);
                // 判断是否回车或者点击列表选择
            } else {
                o_select_list.html("").append(str_search_list);
            }
        }

        // 键盘上下键操作
        mc_select_keyboard_control(o_select_list,e.keyCode,$(this));

        // 控制光标位置在最后
        mc_set_focus($(this));

        // 回车 -> 更新值
        if (13 === e.keyCode) {
        // 列表项与原先项个数不等
            var str_now_val = $(this).text();

            if (arr_option_val.length !== arr_select_list.length) {
                o_select_list.html("").append(str_option_list);


                var arr_option = o_select_list.children();

                for (var idx_val = 0; idx_val < arr_option.length; idx_val++) {
                    if (str_now_val === arr_option.eq(idx_val).text()) {
                        arr_option.eq(idx_val).attr("before_select", "true");
                    }
                }
            } else {
                arr_select_list.eq(i_start).attr("before_select", "true").siblings().attr("before_select", "false");
            }
            o_select_list.css("display","none").attr("star_idx", "false");
            $(this).blur().next().removeClass("select_btn_rotate");
            var o_select = $(this).parent().parent();

            b_edit_step_select = false;

            // 修改默认值
            var str_return_val = "";

            if ("" !== str_now_val) {
                o_select.attr("mc_select_default",str_now_val);
                str_return_val = str_now_select;
            } else {
                str_return_val = o_select.attr("mc_select_default");
                $(this).text(str_return_val);
            }
            var str_id = o_select.attr("id");

            $(this).attr("b_show_default",false);

            // 返回新值
            return_new_value(o_select , str_id , str_return_val);
        }
    });

    // 分类列表
    // 分类头部点击动作 -> 底部样式、内容切换
    $(obj).off("click", ".sc_search_title li");
    $(obj).on("click", ".sc_search_title li", function () {
        var arr_search_title = $(this).parent().children();
        var str_cont_idx = $(this).attr("sc_index");
        var o_search_cont = $(this).parent().nextAll().eq(str_cont_idx);

        // 重置翻页数据为第一页
        i_page = 0;
        mc_limit_data(o_search_cont.children(".sc_cont_right"), i_page);

        for ( var idx_sc_title = 0; idx_sc_title < arr_search_title.length; idx_sc_title++ ) {
            arr_search_title.eq(idx_sc_title).removeClass("sc_title_active");
            $(this).parent().nextAll().eq(idx_sc_title).css("display", "none").removeClass("control_flip");
        }
        $(this).addClass("sc_title_active");
        o_search_cont.css( "display", "flex" ).addClass("control_flip");
        if ("true" === o_search_cont.attr("block_sc_flip")) {
            $(".sc_flip").css("display", "block");
        } else {
            $(".sc_flip").css("display", "none");
        }
    });

    // 点击 X 按钮关闭分类列表
    $(".sc_heard").on("click","span", function () {
        $(this).parent().parent().css("display", "none");
        $(".select_btn_box").removeClass("select_btn_rotate");
        b_edit_step_select = false;
    });

    // 内容点击 -> 选中内容
    $(".sc_cont_list").off("click");
    $(".sc_cont_list").on("click", "li", function () {
        var str_list_val = $(this).text();
        var o_select_classify = $(this).parent().parent().parent().parent();

        o_select_classify.prev().prev().children().eq(0).text(str_list_val);
        $(".select_classify").css("display", "none");
        $(".select_btn_box").removeClass("select_btn_rotate");

        var o_select = o_select_classify.parent();

        // 修改默认值
        if ("" !== str_list_val) {
            o_select.attr("mc_select_default",str_list_val);
        }

        b_edit_step_select = false;
        // 返回新值
        var str_id = o_select.attr("id");
        var str_val = $(this).attr("value");

        return_new_value(o_select,str_id,str_val);
    });

    // 点击上下页切换数据
    $(".sc_flip_prev").off("click");
    $(".sc_flip_prev").on("click", function () {
        if (0 < i_page) {
            i_page -= 1;
        }
        var o_cont_right = $(this).parent().parent().children(".control_flip").children(".sc_cont_right");

        mc_limit_data(o_cont_right, i_page);
        // mc_limit_data(".sc_cont_right", i_page);
    });

    $(".sc_flip_next").off("click");
    $(".sc_flip_next").on("click", function () {
        if (i_all_page - 1 > i_page) {
            i_page += 1;
        }
        var o_cont_right = $(this).parent().parent().children(".control_flip").children(".sc_cont_right");

        mc_limit_data(o_cont_right, i_page);
    });


    // 点击其余位置关闭下拉菜单
    $(document).off("click");
    $(document).on("click",function (event) {
        var o_select_txt = $(".select_txt");
        var o_sc_title_active = $(".sc_title_active");
        var o_select_btn_box = $(".select_btn_box");
        var o_select_btn = $(".select_btn");
        var o_sc_cont_list = $(".sc_cont_list");
        var o_sc_flip_prev = $(".sc_flip_prev");
        var o_sc_flip_next = $(".sc_flip_next");

        if (!o_select_txt.is(event.target) && !o_sc_title_active.is(event.target) && !o_select_btn_box.is(event.target) && !o_select_btn.is(event.target) && !o_sc_cont_list.is(event.target) && !o_sc_flip_prev.is(event.target) && !o_sc_flip_next.is(event.target)) {
            $(".select_classify").css("display","none");
            $(".select_list").css("display","none");
            $(".select_btn_box").removeClass("select_btn_rotate");
            b_edit_step_select = false;
            // 若下拉菜单为空或者输入无匹配项则赋默认值
            for (var idx_item = 0; idx_item < o_select_txt.length; idx_item++) {
                var o_item = o_select_txt.eq(idx_item);
                var str_txt = o_item.text();
                var b_show_default = o_item.attr("b_show_default");

                if ("" === str_txt || "true" === b_show_default) {
                    var str_default_val = o_item.parent().parent().attr("mc_select_default");

                    o_item.text(str_default_val);
                }
            }

            // 下拉列表嵌套在表格时判断 在HUB编辑页面判断
            if (!$(".select_list").parent().prev().is(event.target) && 0 !== $("#box_edit_container").length) {
                $(".select_list").parent().css("display","none").prev().css("display","block");
            }
        }
    });

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    分类列表数据切换处理 每页每种12个
     * 参数:
     *    @param { Promise<Object> } o_obj 事件对象名
     *    @param { Promise<String> } ui_page 数据页数
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 切换成功
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2020.03.04
     *      内容 : 所有代码
     ************************************************************************************************/
    function mc_limit_data(o_obj, ui_page) {
        var arr_list_data = $(o_obj).children();

        if (0 === arr_list_data.length) {
            return true;
        }
        // 第0页时记录最大数据数
        var i_max_data_len = 0;
        // 每页数量
        var i_page_num = 12;

        //其他页 每页60项
        // if (0 === $(o_obj).prev().length) {
        //     i_page_num = 60;
        //     $(o_obj).children(".sc_cont_list").css("height","250px");
        // }


        for (var idx_ul = 0; idx_ul < arr_list_data.length; idx_ul++) {
            var arr_data_li = arr_list_data.eq(idx_ul).children();

            if (i_page_num < arr_data_li.length) {
                arr_data_li.css("display", "none");
                for (var idx_li = i_page_num * ui_page; idx_li < i_page_num * ui_page + i_page_num; idx_li++) {
                    arr_data_li.eq(idx_li).css("display", "block");
                    if (0 === ui_page && i_max_data_len < arr_data_li.length) {
                        i_max_data_len = arr_data_li.length;
                        // 超过数据标识 做显示翻页按钮处理
                        arr_data_li.parent().parent().parent().attr("block_sc_flip","true");
                    }
                }
            }
            //  else {
            //     arr_data_li.css("display", "block");
            //     arr_data_li.parent().parent().parent().attr("block_sc_flip","false");
            // }
        }
        if (0 === ui_page) {
            i_all_page = Math.ceil(i_max_data_len / i_page_num);
        }
        return true;
    }

    // 初始化第一页显示数据
    // mc_limit_data(".sc_cont_right", 0);

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    键盘动作函数封装 键盘上下键控制列表选中项
     * 参数:
     *    @param { Promise<Object> } o_select_list 下拉列表对象
     *    @param { Promise<Number> } ui_keycode 键盘键码值
     *    @param { Promise<Object> } o_select_txt 当前文本框对象
     * 返回：
     *    无
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2020.03.04
     *      内容 : 所有代码
     ************************************************************************************************/
    function mc_select_keyboard_control(o_select_list,ui_keycode,o_select_txt) {
        // 确定起始位置
        var arr_select_list = o_select_list.children();
        var i_select_len = arr_select_list.length;

        for (var idx_item = 0; idx_item < i_select_len; idx_item++) {
            var o_option = arr_select_list.eq(idx_item);

            o_option.removeClass("select_focus");
            if ("true" === o_option.attr("before_select") && -1 === i_start && "false" !== o_select_list.attr("star_idx")) {
                i_start = idx_item;
                o_select_list.attr("star_idx", "false");
            }
        }

        var i_select_list_heigth = o_select_list.height();
        var i_select_height = arr_select_list.innerHeight();

        // 列表显示项个数;
        var i_option_num = parseInt(i_select_list_heigth / i_select_height,10);
        var i_option_t = 0;

        // TOP 38
        if (38 === ui_keycode) {
            o_select_txt.attr("contenteditable", "false");
            i_start -= 1;
            if (0 > i_start) {
                i_start = i_select_len - 1;
            }
            arr_select_list.eq(i_start).addClass("select_focus");
            o_select_txt.text(arr_select_list.eq(i_start).text());
            str_now_select = arr_select_list.eq(i_start).attr("value");

            // 滚动条动作
            i_option_t = arr_select_list.eq(i_start).position().top;

            if (i_select_list_heigth < (i_start + 1) * i_select_height) {
                o_select_list.scrollTop(i_select_height * i_start);
            }
            if (i_select_list_heigth > (i_start + 1) * i_select_height) {
                o_select_list.scrollTop(0);
            }
        }

        // BOTTOM 40
        if (40 === ui_keycode) {
            o_select_txt.attr("contenteditable", "false");
            i_start += 1;
            arr_select_list.eq(i_start).addClass("select_focus");
            o_select_txt.text(arr_select_list.eq(i_start).text());
            str_now_select = arr_select_list.eq(i_start).attr("value");

            // 滚动条动作
            if (i_select_len > i_start) {
                i_option_t = arr_select_list.eq(i_start).position().top;
            }
            if (i_select_list_heigth < (i_start + 1) * i_select_height) {
                var i_offset_top = i_select_height * (i_start - i_option_num);

                o_select_list.scrollTop(i_offset_top);
            }
            if (0 > i_option_t || i_select_len === i_start) {
                o_select_list.scrollTop(0);
            }

            if (i_select_len - 1 <= i_start) {
                i_start = -1;
            }
        }
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    单选按钮组操作
 * 参数:
 *    @param { Promise<Object> } obj 当前对象
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.20
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_radios_event(obj) {
    // 默认选中操作
    if (0 !== $(obj).length && "" !== $(obj).attr("mc_radio_default")) {
        for (var idx_radio_box = 0, len = $(obj).length; idx_radio_box < len; idx_radio_box++) {
            var o_radio_boxs = $(obj).eq(idx_radio_box);
            var str_default_val = o_radio_boxs.attr("mc_radio_default");

            var arr_radio_items = o_radio_boxs.children();

            for (var idx_radio_item = 0; idx_radio_item < arr_radio_items.length; idx_radio_item++) {
                arr_radio_items[idx_radio_item].classList.remove("mc_radio_select");
                var str_radio_val = arr_radio_items[idx_radio_item].getAttribute("value");

                if (str_radio_val === str_default_val) {
                    arr_radio_items[idx_radio_item].classList.add("mc_radio_select");
                    arr_radio_items[idx_radio_item].setAttribute("radio_select", "true");
                }
            }
        }
    }

    $(obj).children().off("click");
    $(obj).children().on("click", function () {
        var o_radio_box = $(this).parent();
        var arr_radio_item = o_radio_box.children();

        for (var idx_radio = 0; idx_radio < arr_radio_item.length; idx_radio++) {
            arr_radio_item[idx_radio].classList.remove("mc_radio_select");
            arr_radio_item[idx_radio].setAttribute("radio_select","false");
        }
        $(this).addClass("mc_radio_select");
        $(this).attr("radio_select", "true");

        // 将选中项值返回
        var str_id = o_radio_box.attr("id");
        var str_val = $(this).attr("value");

        return_new_value(o_radio_box,str_id,str_val);
    });

    $(obj).children().off("mouseover");
    $(obj).children().on("mouseover", function () {
        var o_radio_box = $(this).parent();
        var arr_radio_item = o_radio_box.children();

        radio_set_class(arr_radio_item);
        $(this).addClass("mc_radio_select");
        $(this).off("mouseleave");
        $(this).on("mouseleave", function () {
            radio_set_class(arr_radio_item);
        });
    });

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    鼠标移入移出设置相关类
   * 参数:
   *    @param {Array} arr_radio_item 当前单选数组
   * 返回：
   *    无
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.20
   *      内容 : 所有代码
   ************************************************************************************************/
    function radio_set_class(arr_radio_item) {
        for (var idx_radio = 0; idx_radio < arr_radio_item.length; idx_radio++) {
            var str_select_radio = arr_radio_item[idx_radio].getAttribute("radio_select");

            // 排除选中项
            if ("true" !== str_select_radio) {
                arr_radio_item[idx_radio].classList.remove("mc_radio_select");
            }
        }
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    表格操作
 * 参数:
 *    @param { Promise<Object> } obj 当前对象
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.26
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_table_event(obj) {
    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    将当前格子坐标及值返回
     * 参数:
     *    @param { Promise<Object> } o_now_grid 当前格子
     * 返回：
     *    无
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.12.26
     *      内容 : 所有代码
     ************************************************************************************************/
    function get_grid_pot(o_now_grid) {
        var arr_grid_pot = [];
        var o_ul_li = o_now_grid.parent().children();
        var o_ul = o_now_grid.parent().parent().children();

        for (var idx_li = 0; idx_li < o_ul_li.length; idx_li++) {
            if (o_ul_li.eq(idx_li)[0] === o_now_grid[0]) {
                arr_grid_pot.push(idx_li);
            }
        }
        for (var idx_ul = 0; idx_ul < o_ul.length; idx_ul++) {
            if (o_ul.eq(idx_ul)[0] === o_now_grid.parent()[0]) {
                arr_grid_pot.push(idx_ul);
            }
        }
        // return arr_grid_pot;
        // 格子坐标
        var i_pot_x = arr_grid_pot[0];
        var i_pot_y = arr_grid_pot[1];
        var str_grid_chg_val = o_now_grid.text();

        var str_fun_name = o_now_grid.parent().parent().parent().attr(g_str_attr_lab_val_chg);

        if ("string" === typeof str_fun_name && 0 < str_fun_name.length) {
            var str_id = o_now_grid.parent().parent().parent().attr("id");
            var fun_callback = g_obj_func_name_map[str_fun_name];

            if ("function" === typeof fun_callback) {
                fun_callback(str_id, str_grid_chg_val, i_pot_x, i_pot_y);
            }
        }
    }

    // 设置高显示滚动条
    if (0 !== $(obj).parent().parent().length) {
        $(obj).parent().parent().addClass("table_flex_box_auto_size");
    }

    $(obj).off("click", "ul li");
    $(obj).on("click", "ul li", function () {
        // 标签隐藏不执行
        if ("none" !== $(this).css("display") && "true" === $(this).attr("contenteditable")) {
            $(this).addClass("mc_table_select_li");
        }
    });

    $(obj).off("blur", "ul li");
    $(obj).on("blur", "ul li", function () {
        if ("none" !== $(this).css("display") && "true" === $(this).attr("contenteditable")) {
            $(this).removeClass("mc_table_select_li");

            // 将回车多余标签删除
            if (1 <= $(this).children().length) {
                $(this).children().remove();
            }
        }
        get_grid_pot($(this));
    });

    $(obj).off("keyup", "ul li");
    $(obj).on("keyup", "ul li", function (event) {
        var e = event || window.event;

        if ("none" !== $(this).css("display") && 13 === e.keyCode) {
            $(this).blur();
        }
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    tab选项卡操作
 * 参数:
 *    @param { Promise<Object> } obj 当前对象
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.01.03
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_tabs_event(obj) {
    // 默认选中 显示
    if (0 !== $(obj).length) {
        for (var idx_tabs_box = 0, len = $(obj).length; idx_tabs_box < len; idx_tabs_box++) {
            var o_tab_box = $(obj).eq(idx_tabs_box);
            var i_default_idx = parseInt(o_tab_box.attr("default_idx"),10);

            var arr_header = o_tab_box.children();

            for (var idx_item = 0; idx_item < arr_header.length; idx_item++) {
                arr_header.eq(idx_item).removeClass("select_tab");

                if (idx_item === i_default_idx) {
                    arr_header.eq(idx_item).addClass("select_tab");
                }
            }
        }
    }

    $(obj).off("click", "div");
    $(obj).on("click", "div", function () {
        var o_parent = $(this).parent();
        var arr_div_list = o_parent.children();
        var str_now_con = $(this).attr("tab_idx");

        for (var idx_li = 0; idx_li < arr_div_list.length; idx_li++) {
            var o_tab_item = arr_div_list.eq(idx_li);

            o_tab_item.removeClass("select_tab");
        }
        $(this).addClass("select_tab");
        o_parent.attr("default_idx",str_now_con);

        // 将当前id与新的值返回
        var str_id = o_parent.attr("id");
        var str_val = $(this).text();

        return_new_value(o_parent,str_id,str_val);
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    选择语言开关操作
 * 参数:
 *    @param { Promise<Object> } obj 当前对象
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.10
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_select_lan_event(obj) {
    $(obj).find("div").off("click");
    $(obj).find("div").on("click", function () {
        var select_ul = $(this).next();
        var select_item = select_ul.children();
        var select_default = $(this).find("span").text();

        if ("none" === select_ul.css("display")) {
            $(this).find("i").addClass("edge_rotate");
            // 修改选中样式
            for (var idx_lan = 0; idx_lan < select_item.length; idx_lan++) {
                if (select_item.eq(idx_lan).text().substr(0, 3) === select_default) {
                    select_item.eq(idx_lan).addClass("select_now_item").siblings().removeClass("select_now_item");
                }
            }
            select_ul.slideDown();
        } else {
            select_ul.slideUp();
            $(this).find("i").removeClass("edge_rotate");
        }
    });

    $(obj).find("li").off("click");
    $(obj).find("li").on("click", function () {
        var select_lan = $(this).parent().prev();
        var select_ul = $(this).parent();

        select_lan.find("span").text($(this).html());

        if ("none" === select_ul.css("display")) {
            select_lan.find("i").addClass("edge_rotate");
            select_ul.slideDown();
        } else {
            select_ul.slideUp();
            select_lan.find("i").removeClass("edge_rotate");
        }

        // 返回选中的语言类型
        var str_val = $(this).html();

        return_new_value(select_lan,"",str_val);
    });

    // 失去焦点收起
    $(obj).find("div").off("blur");
    $(obj).find("div").on("blur", function () {
        var select_ul = $(this).next();

        if ("block" === select_ul.css("display")) {
            $(this).find("i").removeClass("edge_rotate");
            select_ul.slideUp();
        }
    });

    // 点击开关外部收起
    $(obj).parent().off("click");
    $(obj).parent().on("click", function (e) {
        var select_ul = $(obj).find("ul");
        var str_nodename = e.target.nodeName.toUpperCase();

        if ("SPAN" !== str_nodename && "I" !== str_nodename) {
            $(obj).find("div").find("i").removeClass("edge_rotate");
            select_ul.slideUp();
        }
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    重置滚动条
 * 参数:
 *    @param { Promise<String> } str_jq_select 事件对象名
 *    @param { Promise<String> } str_jq_select_scroll 滚动条所在对象名
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.10
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_updata_scroll_bar_after_trans(str_jq_select, str_jq_select_scroll) {
    if ("string" !== typeof str_jq_select || 0 === str_jq_select.length || "string" !== typeof str_jq_select_scroll || 0 === str_jq_select_scroll.length) {
        return;
    }
    // PC端生效
    var b_ispc = mc_ispc();

    if (b_ispc) {
        $(str_jq_select).off("transitionend webkitTransitionEnd");
        $(str_jq_select).on("transitionend webkitTransitionEnd", function () {
            $(str_jq_select_scroll).getNiceScroll().resize();
        });
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    加载添加loading
 * 参数:
 *    @param { Promise<String> } str_text 提示信息
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.13
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_loading_wait(str_text) {
    // if ("string" !== typeof str_text || 0 === str_text.length) {
    //     str_text = "内容加载中，请稍后 ...";
    // }
    var loading_html =
    "<div id='mc_loading_box'><div class='mc_loading_box'><div class='mc_loading'><div class='bounce1'></div><div class='bounce2'></div><div class='bounce3'></div></div><div class='mc_loading_text'>" +
    str_text +
    "</div></div><div class='mc_loading_cover'></div></div>";

    $("#page_container").append(loading_html);
}

// 加载完成去除loading
function mc_loading_wait_remove() {
    $("#mc_loading_box").remove();
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    数值改变返回新数值/元素id及新值
 * 参数:
 *    @param { Promise<Object> } o_obj 触发函数的对象
 *    @param { Promise<String> } str_id 被操作元素的id值
 *    @param { Promise<String> } str_new_value 所要返回的新值
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.03.04
 *      内容 : 所有代码
 ************************************************************************************************/
function return_new_value(o_obj,str_id,str_new_value) {
    var str_fun_name = o_obj.attr(g_str_attr_lab_val_chg);

    if ("string" === typeof str_fun_name && 0 < str_fun_name.length) {
        var fun_callback = g_obj_func_name_map[str_fun_name];

        if ("function" === typeof fun_callback) {
            if ("" === str_id) {
                fun_callback(str_new_value);
            } else {
                fun_callback(str_id,str_new_value);
            }
        }
    }
}
